# si_tests.clients.gcore.box_api.NodeGroupsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_node_group**](NodeGroupsApi.md#v1_create_node_group) | **POST** /v1/admin/node-groups | Create nodegroup
[**v1_delete_node_group**](NodeGroupsApi.md#v1_delete_node_group) | **DELETE** /v1/admin/node-groups/{group_name} | Delete node group
[**v1_get_node_group**](NodeGroupsApi.md#v1_get_node_group) | **GET** /v1/admin/node-groups/{group_name} | Get node group
[**v1_list_node_groups**](NodeGroupsApi.md#v1_list_node_groups) | **GET** /v1/admin/node-groups | List node groups
[**v1_list_node_groups_node**](NodeGroupsApi.md#v1_list_node_groups_node) | **GET** /v1/admin/node-groups/nodes | List nodes in all node groups
[**v1_update_node_group**](NodeGroupsApi.md#v1_update_node_group) | **PUT** /v1/admin/node-groups/{group_name} | Update node group


# **v1_create_node_group**
> V1NodeGroupResponse v1_create_node_group(v1_create_node_group_request)

Create nodegroup

Creates a node group for allocating or reserving compute nodes within a region.

A node group is a logical construct used to assign specific hardware resources
to one or more projects. This allows you to isolate resources for
particular tenants, customers, or workloads.

Key characteristics of node groups:
- One node group can be assigned to multiple projects
- One node group can contain nodes from different regions
- One node can only be added to one node group
- One project can only have one node group assigned
- A project with a node group assigned will only be able to see and use nodes from that group
- When a node group is assigned to a project, all existing deployments will be migrated to nodes in the group

Each node group includes a unique name, a list of target projects, optional custom labels,
and node references that associate available nodes with the group.

Note: Custom labels are for informational purposes only. They are added to deployments
but do not affect scheduling.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_node_group_request import V1CreateNodeGroupRequest
from si_tests.clients.gcore.box_api.models.v1_node_group_response import V1NodeGroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodeGroupsApi(api_client)
    v1_create_node_group_request = si_tests.clients.gcore.box_api.V1CreateNodeGroupRequest() # V1CreateNodeGroupRequest | NodeGroup body

    try:
        # Create nodegroup
        api_response = api_instance.v1_create_node_group(v1_create_node_group_request)
        print("The response of NodeGroupsApi->v1_create_node_group:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NodeGroupsApi->v1_create_node_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_node_group_request** | [**V1CreateNodeGroupRequest**](V1CreateNodeGroupRequest.md)| NodeGroup body | 

### Return type

[**V1NodeGroupResponse**](V1NodeGroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_node_group**
> v1_delete_node_group(group_name)

Delete node group

Deletes the specified node group.

When a node group is deleted:
- Any projects previously assigned to this group will no longer have node group restrictions
- Deployments in those projects will be able to use any available nodes in the system
- The node assignments related to the group will be released
- Existing running deployments might be rescheduled to other nodes

Note: This does not delete the underlying nodes themselves.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodeGroupsApi(api_client)
    group_name = 'group_name_example' # str | NodeGroup name

    try:
        # Delete node group
        api_instance.v1_delete_node_group(group_name)
    except Exception as e:
        print("Exception when calling NodeGroupsApi->v1_delete_node_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_name** | **str**| NodeGroup name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_node_group**
> V1NodeGroupResponse v1_get_node_group(group_name)

Get node group

Retrieves detailed information about a specific node group.

This includes its name, associated projects, custom labels, and
references to allocated nodes.

Key characteristics of node groups:
- One node group can be assigned to multiple projects
- One node group can contain nodes from different regions
- One node can only be added to one node group
- One project can only have one node group assigned
- A project with a node group assigned will only be able to see and use nodes from that group

Note: Custom labels are for informational purposes only. They are added to deployments
but do not affect scheduling.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_node_group_response import V1NodeGroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodeGroupsApi(api_client)
    group_name = 'group_name_example' # str | NodeGroup name

    try:
        # Get node group
        api_response = api_instance.v1_get_node_group(group_name)
        print("The response of NodeGroupsApi->v1_get_node_group:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NodeGroupsApi->v1_get_node_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_name** | **str**| NodeGroup name | 

### Return type

[**V1NodeGroupResponse**](V1NodeGroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_node_groups**
> V1ListNodeGroupResponse v1_list_node_groups()

List node groups

Retrieves all node groups.

Node groups are logical groupings of compute nodes associated with one or more projects.
Key characteristics of node groups:
- One node group can be assigned to multiple projects
- One node group can contain nodes from different regions
- One node can only be added to one node group

Use this endpoint to inspect existing node group configurations.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_node_group_response import V1ListNodeGroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodeGroupsApi(api_client)

    try:
        # List node groups
        api_response = api_instance.v1_list_node_groups()
        print("The response of NodeGroupsApi->v1_list_node_groups:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NodeGroupsApi->v1_list_node_groups: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListNodeGroupResponse**](V1ListNodeGroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_node_groups_node**
> ApiServicesNodegroupsV1ListNodesResponse v1_list_node_groups_node()

List nodes in all node groups

Lists all nodes associated with node groups across all regions.

This endpoint provides a global view of node-to-nodegroup associations,
useful for debugging capacity distribution and verifying hardware assignments.

Key characteristics of node groups and nodes:
- One node can only be added to one node group
- One node group can contain nodes from different regions
- Nodes assigned to a node group will only be available to projects associated with that group

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_list_nodes_response import ApiServicesNodegroupsV1ListNodesResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodeGroupsApi(api_client)

    try:
        # List nodes in all node groups
        api_response = api_instance.v1_list_node_groups_node()
        print("The response of NodeGroupsApi->v1_list_node_groups_node:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NodeGroupsApi->v1_list_node_groups_node: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ApiServicesNodegroupsV1ListNodesResponse**](ApiServicesNodegroupsV1ListNodesResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_node_group**
> V1NodeGroupResponse v1_update_node_group(group_name, v1_update_node_group_request)

Update node group

Updates an existing node group’s configuration.

Use this endpoint to change the associated projects, custom labels,
or the underlying node references for a specific group.

Key characteristics of node groups:
- One node group can be assigned to multiple projects
- One node group can contain nodes from different regions
- One node can only be added to one node group
- One project can only have one node group assigned
- A project with a node group assigned will only be able to see and use nodes from that group
- When a node group is assigned to a project, all existing deployments will be migrated to nodes in the group

Note: Custom labels are for informational purposes only. They are added to deployments
but do not affect scheduling.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_node_group_response import V1NodeGroupResponse
from si_tests.clients.gcore.box_api.models.v1_update_node_group_request import V1UpdateNodeGroupRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodeGroupsApi(api_client)
    group_name = 'group_name_example' # str | NodeGroup name
    v1_update_node_group_request = si_tests.clients.gcore.box_api.V1UpdateNodeGroupRequest() # V1UpdateNodeGroupRequest | NodeGroup body

    try:
        # Update node group
        api_response = api_instance.v1_update_node_group(group_name, v1_update_node_group_request)
        print("The response of NodeGroupsApi->v1_update_node_group:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NodeGroupsApi->v1_update_node_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_name** | **str**| NodeGroup name | 
 **v1_update_node_group_request** | [**V1UpdateNodeGroupRequest**](V1UpdateNodeGroupRequest.md)| NodeGroup body | 

### Return type

[**V1NodeGroupResponse**](V1NodeGroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

