# si_tests.clients.gcore.box_api.FlavorsManagementApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_flavor**](FlavorsManagementApi.md#v1_create_flavor) | **POST** /v1/admin/flavors | Create flavor
[**v1_delete_flavor**](FlavorsManagementApi.md#v1_delete_flavor) | **DELETE** /v1/admin/flavors/{flavor_name} | Delete flavor


# **v1_create_flavor**
> V1FlavorResponse v1_create_flavor(v1_create_flavor_request)

Create flavor

This endpoint creates a new flavor with the specified compute resources.

A flavor defines the compute resources (CPU, memory, GPU) available for inference deployments.
Use this endpoint when you need to define a new resource configuration for your deployments.

When creating a flavor, you can specify:
- CPU and memory requirements
- GPU model and amount
- Whether the GPU is shared (MIG-enabled)

Note: The `is_gpu_shared` parameter is related to MIG (NVIDIA Multi-Instance GPU).
MIG can partition the GPU into as many as seven instances, each fully isolated with its own high-bandwidth memory, cache, and compute cores.
Set this to true if you want to create a MIG flavor.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_flavor_request import V1CreateFlavorRequest
from si_tests.clients.gcore.box_api.models.v1_flavor_response import V1FlavorResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.FlavorsManagementApi(api_client)
    v1_create_flavor_request = si_tests.clients.gcore.box_api.V1CreateFlavorRequest() # V1CreateFlavorRequest | Flavor body

    try:
        # Create flavor
        api_response = api_instance.v1_create_flavor(v1_create_flavor_request)
        print("The response of FlavorsManagementApi->v1_create_flavor:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling FlavorsManagementApi->v1_create_flavor: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_flavor_request** | [**V1CreateFlavorRequest**](V1CreateFlavorRequest.md)| Flavor body | 

### Return type

[**V1FlavorResponse**](V1FlavorResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_flavor**
> v1_delete_flavor(flavor_name)

Delete flavor

This endpoint removes a flavor from the system.

Use this endpoint when you need to:
- Remove a resource configuration that is no longer needed
- Clean up unused or obsolete flavors

Note: You cannot delete a flavor that is currently used by any deployments.
The system will validate and prevent deletion if there are deployments using the flavor.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.FlavorsManagementApi(api_client)
    flavor_name = 'flavor_name_example' # str | Flavor name

    try:
        # Delete flavor
        api_instance.v1_delete_flavor(flavor_name)
    except Exception as e:
        print("Exception when calling FlavorsManagementApi->v1_delete_flavor: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flavor_name** | **str**| Flavor name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

