# si_tests.clients.gcore.box_api.FlavorsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_get_flavor**](FlavorsApi.md#v1_get_flavor) | **GET** /v1/flavors/{flavor_name} | Get flavor
[**v1_list_flavors**](FlavorsApi.md#v1_list_flavors) | **GET** /v1/flavors | List flavors


# **v1_get_flavor**
> V1FlavorResponse v1_get_flavor(flavor_name)

Get flavor

This endpoint retrieves detailed information about a specific flavor by name.

A flavor defines the compute resources (CPU, memory, GPU) available for inference deployments.
Use this endpoint when you need to examine the configuration of a particular flavor or verify its properties.

Note: If the flavor has `is_gpu_shared` set to true, it is a MIG (NVIDIA Multi-Instance GPU) flavor.
MIG can partition the GPU into as many as seven instances, each fully isolated with its own high-bandwidth memory, cache, and compute cores.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_flavor_response import V1FlavorResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.FlavorsApi(api_client)
    flavor_name = 'flavor_name_example' # str | Flavor name

    try:
        # Get flavor
        api_response = api_instance.v1_get_flavor(flavor_name)
        print("The response of FlavorsApi->v1_get_flavor:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling FlavorsApi->v1_get_flavor: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flavor_name** | **str**| Flavor name | 

### Return type

[**V1FlavorResponse**](V1FlavorResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_flavors**
> V1ListFlavorResponse v1_list_flavors()

List flavors

This endpoint retrieves a list of all available flavors in the system.

Flavors define the compute resources (CPU, memory, GPU) available for inference deployments.
Use this endpoint to get an overview of all available resource configurations for planning your deployments.

Note: If a flavor has `is_gpu_shared` set to true, it is a MIG (NVIDIA Multi-Instance GPU) flavor.
MIG can partition the GPU into as many as seven instances, each fully isolated with its own high-bandwidth memory, cache, and compute cores.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_flavor_response import V1ListFlavorResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.FlavorsApi(api_client)

    try:
        # List flavors
        api_response = api_instance.v1_list_flavors()
        print("The response of FlavorsApi->v1_list_flavors:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling FlavorsApi->v1_list_flavors: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListFlavorResponse**](V1ListFlavorResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

