# si_tests.clients.gcore.box_api.AutodiscoveryApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_sub_region**](AutodiscoveryApi.md#v1_create_sub_region) | **POST** /v1/admin/autodiscovery/subregions | Create edge region
[**v1_delete_sub_region**](AutodiscoveryApi.md#v1_delete_sub_region) | **DELETE** /v1/admin/autodiscovery/subregions/{subregion_name} | Delete edge region
[**v1_get_sub_region**](AutodiscoveryApi.md#v1_get_sub_region) | **GET** /v1/admin/autodiscovery/subregions/{subregion_name} | Get edge region
[**v1_list_nodes**](AutodiscoveryApi.md#v1_list_nodes) | **GET** /v1/admin/autodiscovery/nodes | List nodes
[**v1_list_sub_region**](AutodiscoveryApi.md#v1_list_sub_region) | **GET** /v1/admin/autodiscovery/subregions | List edge regions
[**v1_update_sub_region**](AutodiscoveryApi.md#v1_update_sub_region) | **PUT** /v1/admin/autodiscovery/subregions/{subregion_name} | Update edge region


# **v1_create_sub_region**
> V1SubRegionResponse v1_create_sub_region(v1_create_sub_region_request)

Create edge region

This endpoint creates a new edge region with the specified properties.

Use this endpoint to create an edge region, which represents a geographical area containing multiple nodes at a single remote location (without a Kubernetes cluster) and is associated with a core region.
Creating edge regions allows you to organize your nodes geographically, which can be useful for:
- Optimizing resource allocation based on geographical proximity
- Implementing region-specific policies or configurations
- Improving application performance by placing resources closer to users

To create an edge region, first list all nodes using the `/v1/admin/autodiscovery/nodes` endpoint,
then select the nodes with empty region values and use them for your new edge region.

Note: Both `core` regions and `edge` regions are returned by the /v1/regions endpoint.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_sub_region_request import V1CreateSubRegionRequest
from si_tests.clients.gcore.box_api.models.v1_sub_region_response import V1SubRegionResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AutodiscoveryApi(api_client)
    v1_create_sub_region_request = si_tests.clients.gcore.box_api.V1CreateSubRegionRequest() # V1CreateSubRegionRequest | Subregion body

    try:
        # Create edge region
        api_response = api_instance.v1_create_sub_region(v1_create_sub_region_request)
        print("The response of AutodiscoveryApi->v1_create_sub_region:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AutodiscoveryApi->v1_create_sub_region: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_sub_region_request** | [**V1CreateSubRegionRequest**](V1CreateSubRegionRequest.md)| Subregion body | 

### Return type

[**V1SubRegionResponse**](V1SubRegionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_sub_region**
> v1_delete_sub_region(subregion_name)

Delete edge region

This endpoint removes a edge region from the system.

Edge regions combine multiple nodes in a single remote location (without a Kubernetes cluster) into a single region of type `edge`.
When a edge region is deleted and there are deployments running on its nodes:
- The pods will be unscheduled
- The deployments will remain visible and manageable
- You can either delete these deployments or update them to use other regions

Note: Deleting a edge region does not delete the nodes that were associated with it.
Those nodes will still exist but will no longer be part of the deleted edge region.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AutodiscoveryApi(api_client)
    subregion_name = 'subregion_name_example' # str | Subregion name

    try:
        # Delete edge region
        api_instance.v1_delete_sub_region(subregion_name)
    except Exception as e:
        print("Exception when calling AutodiscoveryApi->v1_delete_sub_region: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **subregion_name** | **str**| Subregion name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_sub_region**
> V1SubRegionResponse v1_get_sub_region(subregion_name)

Get edge region

This endpoint retrieves detailed information about a specific `edge` region by name.

Edge regions combine multiple nodes in a single remote location (without a Kubernetes cluster) into a single region of type `edge`.
The response includes the edge region's associated nodes, core region, and networking properties.
Use this endpoint when you need to examine the configuration of a particular edge region or verify its properties.
This is particularly useful for troubleshooting or when planning to update a edge region's configuration.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_sub_region_response import V1SubRegionResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AutodiscoveryApi(api_client)
    subregion_name = 'subregion_name_example' # str | Subregion name

    try:
        # Get edge region
        api_response = api_instance.v1_get_sub_region(subregion_name)
        print("The response of AutodiscoveryApi->v1_get_sub_region:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AutodiscoveryApi->v1_get_sub_region: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **subregion_name** | **str**| Subregion name | 

### Return type

[**V1SubRegionResponse**](V1SubRegionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_nodes**
> ApiServicesAutodiscoveriesV1ListNodesResponse v1_list_nodes()

List nodes

This endpoint returns only nodes in `edge` regions, excluding nodes from `core` regions.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_list_nodes_response import ApiServicesAutodiscoveriesV1ListNodesResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AutodiscoveryApi(api_client)

    try:
        # List nodes
        api_response = api_instance.v1_list_nodes()
        print("The response of AutodiscoveryApi->v1_list_nodes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AutodiscoveryApi->v1_list_nodes: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ApiServicesAutodiscoveriesV1ListNodesResponse**](ApiServicesAutodiscoveriesV1ListNodesResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_sub_region**
> V1ListSubRegionResponse v1_list_sub_region()

List edge regions

This endpoint retrieves a list of all `edge` regions in the system.

Edge regions are geographical divisions that contain nodes in a single remote location (without a Kubernetes cluster) and are associated with core regions.
Use this endpoint to get an overview of all available edge regions, their locations, and associated nodes.
This information is useful for resource planning and understanding the geographical distribution of your infrastructure.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_sub_region_response import V1ListSubRegionResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AutodiscoveryApi(api_client)

    try:
        # List edge regions
        api_response = api_instance.v1_list_sub_region()
        print("The response of AutodiscoveryApi->v1_list_sub_region:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AutodiscoveryApi->v1_list_sub_region: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListSubRegionResponse**](V1ListSubRegionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_sub_region**
> V1SubRegionResponse v1_update_sub_region(subregion_name, v1_update_sub_region_request)

Update edge region

This endpoint updates an existing edge region's properties.

Edge regions combine multiple nodes in a single remote location (without a Kubernetes cluster) into a single region of type `edge“.
You can modify the billing name, GPU availability, geographical coordinates, and the set of nodes associated with the edge region.
Use this endpoint when you need to:
- Adjust the geographical location of a edge region
- Add or remove nodes from a edge region
- Update the billing information
- Change GPU availability settings

Note: Properties not included in the update request will retain their current values.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_sub_region_response import V1SubRegionResponse
from si_tests.clients.gcore.box_api.models.v1_update_sub_region_request import V1UpdateSubRegionRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AutodiscoveryApi(api_client)
    subregion_name = 'subregion_name_example' # str | Subregion name
    v1_update_sub_region_request = si_tests.clients.gcore.box_api.V1UpdateSubRegionRequest() # V1UpdateSubRegionRequest | Subregion body

    try:
        # Update edge region
        api_response = api_instance.v1_update_sub_region(subregion_name, v1_update_sub_region_request)
        print("The response of AutodiscoveryApi->v1_update_sub_region:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AutodiscoveryApi->v1_update_sub_region: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **subregion_name** | **str**| Subregion name | 
 **v1_update_sub_region_request** | [**V1UpdateSubRegionRequest**](V1UpdateSubRegionRequest.md)| Subregion body | 

### Return type

[**V1SubRegionResponse**](V1SubRegionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

