# ApiServicesOverviewV1Pod


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**inference_flavor_name** | **str** | InferenceFlavorName is the inference flavor used by the inference deployment. | [optional] 
**inference_name** | **str** | InferenceName is the associated inference deployment name. | [optional] 
**name** | **str** | Name is the pod name. | [optional] 
**namespace** | **str** | Namespace is the Kubernetes namespace. | [optional] 
**node_name** | **str** | NodeName is the name of the node where the pod is scheduled. | [optional] 
**region_name** | **str** | RegionName is the region where the inference deployment is running. | [optional] 
**requested_resources** | **Dict[str, str]** | RequestedResources lists requested compute resources as a map of resource name to amount. Examples: cpu:4, memory:16Gi, nvidia.com/gpu:1 | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_pod import ApiServicesOverviewV1Pod

# TODO update the JSON string below
json = "{}"
# create an instance of ApiServicesOverviewV1Pod from a JSON string
api_services_overview_v1_pod_instance = ApiServicesOverviewV1Pod.from_json(json)
# print the JSON string representation of the object
print(ApiServicesOverviewV1Pod.to_json())

# convert the object into a dict
api_services_overview_v1_pod_dict = api_services_overview_v1_pod_instance.to_dict()
# create an instance of ApiServicesOverviewV1Pod from a dict
api_services_overview_v1_pod_from_dict = ApiServicesOverviewV1Pod.from_dict(api_services_overview_v1_pod_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


