# si_tests.clients.gcore.box_api.APIKeysApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_api_key**](APIKeysApi.md#v1_create_api_key) | **POST** /v1/{project_name}/apikeys | Create API key
[**v1_delete_api_key**](APIKeysApi.md#v1_delete_api_key) | **DELETE** /v1/{project_name}/apikeys/{name} | Delete API key
[**v1_delete_api_key_rate_limits**](APIKeysApi.md#v1_delete_api_key_rate_limits) | **DELETE** /v1/admin/{project_name}/apikeys/{apikey_name}/rate-limits | Delete apikey rate limits
[**v1_get_api_key**](APIKeysApi.md#v1_get_api_key) | **GET** /v1/{project_name}/apikeys/{name} | Get API key
[**v1_get_api_key_rate_limits**](APIKeysApi.md#v1_get_api_key_rate_limits) | **GET** /v1/admin/{project_name}/apikeys/{apikey_name}/rate-limits | Get API key rate limits
[**v1_list_api_keys**](APIKeysApi.md#v1_list_api_keys) | **GET** /v1/{project_name}/apikeys | List API keys
[**v1_patch_api_key**](APIKeysApi.md#v1_patch_api_key) | **PATCH** /v1/{project_name}/apikeys/{name} | Patch API key
[**v1_update_api_key**](APIKeysApi.md#v1_update_api_key) | **PUT** /v1/{project_name}/apikeys/{name} | Update API key
[**v1_update_api_key_rate_limits**](APIKeysApi.md#v1_update_api_key_rate_limits) | **PUT** /v1/admin/{project_name}/apikeys/{apikey_name}/rate-limits | Update API key rate limits


# **v1_create_api_key**
> V1CreateApiKeyResponse v1_create_api_key(project_name, v1_create_api_key_request)

Create API key

Creates a new API key in the specified project.

Note: These API keys are used to authenticate HTTP requests to your deployed inference applications. They are not used for authenticating with the API itself.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_api_key_request import V1CreateApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_create_api_key_response import V1CreateApiKeyResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_api_key_request = si_tests.clients.gcore.box_api.V1CreateApiKeyRequest() # V1CreateApiKeyRequest | API key configuration

    try:
        # Create API key
        api_response = api_instance.v1_create_api_key(project_name, v1_create_api_key_request)
        print("The response of APIKeysApi->v1_create_api_key:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_create_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_api_key_request** | [**V1CreateApiKeyRequest**](V1CreateApiKeyRequest.md)| API key configuration | 

### Return type

[**V1CreateApiKeyResponse**](V1CreateApiKeyResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_api_key**
> v1_delete_api_key(project_name, name)

Delete API key

Deletes an API key from the specified project.

Note: These API keys are used to authenticate HTTP requests to your deployed inference applications. They are not used for authenticating with the API itself.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    name = 'name_example' # str | API key name

    try:
        # Delete API key
        api_instance.v1_delete_api_key(project_name, name)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_delete_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **name** | **str**| API key name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |
**409** | Conflict |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_api_key_rate_limits**
> v1_delete_api_key_rate_limits(project_name, apikey_name)

Delete apikey rate limits

This endpoint deletes rate limits configured for this API key.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    apikey_name = 'apikey_name_example' # str | Project name

    try:
        # Delete apikey rate limits
        api_instance.v1_delete_api_key_rate_limits(project_name, apikey_name)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_delete_api_key_rate_limits: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **apikey_name** | **str**| Project name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_api_key**
> V1ApiKeyResponse v1_get_api_key(project_name, name)

Get API key

Returns detailed information about a specific API key in the project.

Note: These API keys are used to authenticate HTTP requests to your deployed inference applications. They are not used for authenticating with the API itself.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_api_key_response import V1ApiKeyResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    name = 'name_example' # str | API key name

    try:
        # Get API key
        api_response = api_instance.v1_get_api_key(project_name, name)
        print("The response of APIKeysApi->v1_get_api_key:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_get_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **name** | **str**| API key name | 

### Return type

[**V1ApiKeyResponse**](V1ApiKeyResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_api_key_rate_limits**
> V1ApiKeyRateLimitsResponse v1_get_api_key_rate_limits(project_name, apikey_name)

Get API key rate limits

This endpoint returns rate limits configured for this API key.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_api_key_rate_limits_response import V1ApiKeyRateLimitsResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    apikey_name = 'apikey_name_example' # str | API key name

    try:
        # Get API key rate limits
        api_response = api_instance.v1_get_api_key_rate_limits(project_name, apikey_name)
        print("The response of APIKeysApi->v1_get_api_key_rate_limits:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_get_api_key_rate_limits: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **apikey_name** | **str**| API key name | 

### Return type

[**V1ApiKeyRateLimitsResponse**](V1ApiKeyRateLimitsResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_api_keys**
> V1ListApiKeysResponse v1_list_api_keys(project_name)

List API keys

Returns a list of all API keys in the specified project.

Note: These API keys are used to authenticate HTTP requests to your deployed inference applications. They are not used for authenticating with the API itself.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_api_keys_response import V1ListApiKeysResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List API keys
        api_response = api_instance.v1_list_api_keys(project_name)
        print("The response of APIKeysApi->v1_list_api_keys:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_list_api_keys: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListApiKeysResponse**](V1ListApiKeysResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_patch_api_key**
> V1ApiKeyResponse v1_patch_api_key(project_name, name, v1_patch_api_key_request)

Patch API key

Patches an existing API key in the specified project.

Note: These API keys are used to authenticate HTTP requests to your deployed inference applications.
They are not used for authenticating with the API itself.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_api_key_response import V1ApiKeyResponse
from si_tests.clients.gcore.box_api.models.v1_patch_api_key_request import V1PatchApiKeyRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    name = 'name_example' # str | API key name
    v1_patch_api_key_request = si_tests.clients.gcore.box_api.V1PatchApiKeyRequest() # V1PatchApiKeyRequest | API key configuration to update

    try:
        # Patch API key
        api_response = api_instance.v1_patch_api_key(project_name, name, v1_patch_api_key_request)
        print("The response of APIKeysApi->v1_patch_api_key:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_patch_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **name** | **str**| API key name | 
 **v1_patch_api_key_request** | [**V1PatchApiKeyRequest**](V1PatchApiKeyRequest.md)| API key configuration to update | 

### Return type

[**V1ApiKeyResponse**](V1ApiKeyResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**401** | Unauthorized |  -  |
**404** | Not Found |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_api_key**
> V1ApiKeyResponse v1_update_api_key(project_name, name, v1_update_api_key_request)

Update API key

Updates an existing API key in the specified project.

Note: These API keys are used to authenticate HTTP requests to your deployed inference applications.
They are not used for authenticating with the API itself.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_api_key_response import V1ApiKeyResponse
from si_tests.clients.gcore.box_api.models.v1_update_api_key_request import V1UpdateApiKeyRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    name = 'name_example' # str | API key name
    v1_update_api_key_request = si_tests.clients.gcore.box_api.V1UpdateApiKeyRequest() # V1UpdateApiKeyRequest | API key configuration to update

    try:
        # Update API key
        api_response = api_instance.v1_update_api_key(project_name, name, v1_update_api_key_request)
        print("The response of APIKeysApi->v1_update_api_key:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_update_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **name** | **str**| API key name | 
 **v1_update_api_key_request** | [**V1UpdateApiKeyRequest**](V1UpdateApiKeyRequest.md)| API key configuration to update | 

### Return type

[**V1ApiKeyResponse**](V1ApiKeyResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**401** | Unauthorized |  -  |
**404** | Not Found |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_api_key_rate_limits**
> V1ApiKeyRateLimitsResponse v1_update_api_key_rate_limits(project_name, apikey_name, v1_update_api_key_rate_limits_request)

Update API key rate limits

This endpoint updates rate limits for this API key.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_api_key_rate_limits_response import V1ApiKeyRateLimitsResponse
from si_tests.clients.gcore.box_api.models.v1_update_api_key_rate_limits_request import V1UpdateApiKeyRateLimitsRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.APIKeysApi(api_client)
    project_name = 'project_name_example' # str | Project name
    apikey_name = 'apikey_name_example' # str | API key name
    v1_update_api_key_rate_limits_request = si_tests.clients.gcore.box_api.V1UpdateApiKeyRateLimitsRequest() # V1UpdateApiKeyRateLimitsRequest | Rate limits body

    try:
        # Update API key rate limits
        api_response = api_instance.v1_update_api_key_rate_limits(project_name, apikey_name, v1_update_api_key_rate_limits_request)
        print("The response of APIKeysApi->v1_update_api_key_rate_limits:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->v1_update_api_key_rate_limits: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **apikey_name** | **str**| API key name | 
 **v1_update_api_key_rate_limits_request** | [**V1UpdateApiKeyRateLimitsRequest**](V1UpdateApiKeyRateLimitsRequest.md)| Rate limits body | 

### Return type

[**V1ApiKeyRateLimitsResponse**](V1ApiKeyRateLimitsResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

