#!/usr/bin/env python3

import os
import sys

sys.path.append(os.getcwd())
try:
    from si_tests import settings
    from si_tests.managers.kaas_manager import Manager
except ImportError:
    print("ImportError: Run the application from the si-tests directory or "
          "set the PYTHONPATH environment variable to directory which contains"
          " ./si_tests")
    sys.exit(1)


def main():
    if not settings.KUBECONFIG_PATH or not os.path.isfile(
            settings.KUBECONFIG_PATH):
        print("Please set KUBECONFIG environment variable whith"
              "the path to the kubeconfig file for KaaS management cluster")
        return 11

    kaas_manager = Manager(kubeconfig=settings.KUBECONFIG_PATH)
    ucp_version = kaas_manager.si_config.version_generators.gen_supported_mke_versions()
    print('\n'.join(ucp_version))


if __name__ == '__main__':
    sys.exit(main())
