import re

from si_tests import settings


def get_cluster_kubeconfig(remote, cluster_name, provider):
    kubeconfig_output = "kubeconfig"
    kubeconfig_path = settings.KUBECONFIG_KIND_PATH
    if provider == settings.BAREMETAL_PROVIDER_NAME:
        # FIXME(alexz) quick-wa till jjb-si will be merged.
        # see https://miracloud.slack.com/archives/CKG6GDXUP/p1708628439029189
        _old_incorrect = f"{settings.KAAS_BOOTSTRAP_TARGET_DIR}/{settings.KUBECONFIG_KIND_PATH}"
        _new_correct = settings.KUBECONFIG_KIND_PATH
        if remote.isfile(_old_incorrect):
            kubeconfig_path = _old_incorrect
        elif remote.isfile(_new_correct):
            kubeconfig_path = _new_correct
        else:
            raise Exception('Target kind kubeconfig not found')
        kubeconfig_output = f"{settings.KAAS_BOOTSTRAP_TARGET_DIR}/{kubeconfig_output}"
    try:
        result = remote.execute(
            command=f"./{settings.KAAS_BOOTSTRAP_TARGET_DIR}/container-cloud get cluster-kubeconfig " +
            f"--cluster-name {cluster_name} " +
            f"--kubeconfig-output {kubeconfig_output} " +
            f"--kubeconfig {kubeconfig_path}",
            verbose=True, timeout=30)
        return result and result.exit_code == 0
    except Exception:
        return False


def is_bootstrap_version_dev(version):
    rx_dev = r'\d+\.\d+\.\d+-\d+-[0-9a-f]+'
    return re.match(rx_dev, version)


def extract_clean_kaasrelease_version(kr_name):
    rx_clean = r'\d+.\d+.\d+'
    return re.search(rx_clean, kr_name).group(0)
