import pytest
import json

from si_tests import settings
from si_tests import logger


LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_add_nodes_os_mgmt_region(kaas_manager, show_step, _):
    """Add nodes to the child cluster."""

    # Collecting env data
    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE
    error_message = "adding machines to management " \
                    "cluster is not supported"
    # Get namespace
    LOG.info("Namespace name - %s", namespace_name)
    ns = kaas_manager.get_namespace(namespace_name)
    cluster = ns.get_cluster(cluster_name)
    region = kaas_manager.get_mgmt_cluster().region_name

    existing_master_node = cluster.get_machines(machine_type='control')[0]

    machine_flavor_name = \
        existing_master_node.data['spec']['providerSpec']['value']['flavor']

    machine_image_name = \
        existing_master_node.data['spec']['providerSpec']['value']['image']

    machine_az_name = \
        existing_master_node.data['spec']['providerSpec']['value'][
            'availabilityZone']

    LOG.info("Trying to add 1 master node")
    try:
        cluster.create_os_machine(
            node_type="master",
            region=region,
            node_flavor=machine_flavor_name,
            node_image=machine_image_name,
            node_az=machine_az_name)
    except Exception as e:
        message = json.loads(e.body)['message']
        if e.status != 400 or error_message not in message:
            raise e
        else:
            LOG.info("Can't add machine to mgmt/region cluster as expected")
    else:
        pytest.fail("It is possible to add master node for cluster. Exiting")

    LOG.info("Trying to add 1 slave node")
    try:
        cluster.create_os_machine(
            node_type="node",
            region=region,
            node_flavor=machine_flavor_name,
            node_image=machine_image_name,
            node_az=machine_az_name)
    except Exception as e:
        message = json.loads(e.body)['message']
        if e.status != 400 or error_message not in message:
            raise e
        else:
            LOG.info("Can't add machine to mgmt/region cluster as expected")
    else:
        pytest.fail("It is possible to add slave node for cluster. Exiting")
