#!/usr/bin/env bash


function _KILL_JOBS() {
  for pid in $(jobs -r -p); do
    if [[ $(ps -p $pid) && $? -eq 0 ]]; then
      kill $pid
    fi
  done
}

function _INT_TERM() {
  echo ""
  echo ["EXIT"]

  _KILL_JOBS

  exit 1;
}

trap _INT_TERM INT TERM
trap _KILL_JOBS EXIT


function set_power(){
  local ACTION=${1:-'status'}
  local TARGET=${2:-'all'}

  local DEFAULT_IPMI="172.18.168.10"
  local DEFAULT_LOGIN="admin"
  local DEFAULT_PASSWORD="password"

  # name ipmi_ip ipmi_port ipmi_login ipmi_password
  local MGMT=(
    'vm-408-0' $DEFAULT_IPMI '50020' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-1' $DEFAULT_IPMI '50021' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-2' $DEFAULT_IPMI '50022' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  local CHILD=(
    'vm-408-3' $DEFAULT_IPMI '50023' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-4' $DEFAULT_IPMI '50024' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-5' $DEFAULT_IPMI '50025' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-6' $DEFAULT_IPMI '50026' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-7' $DEFAULT_IPMI '50027' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-8' $DEFAULT_IPMI '50028' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-9' $DEFAULT_IPMI '50096' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-10' $DEFAULT_IPMI '50097' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-11' $DEFAULT_IPMI '50098' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-12' $DEFAULT_IPMI '50099' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-13' $DEFAULT_IPMI '50100' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-14' $DEFAULT_IPMI '50101' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-15' $DEFAULT_IPMI '50029' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-16' $DEFAULT_IPMI '50030' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-17' $DEFAULT_IPMI '50031' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-18' $DEFAULT_IPMI '50032' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-408-19' $DEFAULT_IPMI '50033' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  case $TARGET in
    mgmt) ARR=( ${MGMT[@]} );
      ;;
    child) ARR=( ${CHILD[@]} );
      ;;
    all) ARR=( ${MGMT[@]} ${CHILD[@]} );
      ;;
  esac

  for i in $(seq 0 5 $(expr ${#ARR[@]} - 1)); do
    echo "node: ${ARR[i]}"
    CMD=(ipmitool -I lanplus -H ${ARR[i+1]} -p ${ARR[i+2]} -U ${ARR[i+3]} -P ${ARR[i+4]} chassis power $ACTION)
    echo ${CMD[@]}

    ${CMD[@]}
  done
}

#main
if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    set_power "$@"
fi