import pytest

from si_tests import settings
from si_tests import logger


LOG = logger.logger


def _post_action_stop_mm_mode(cluster):
    # Check mm status on cluster
    cluster_status = cluster.data.get('status') or {}
    current_status = cluster_status.get('providerStatus', {}).get('maintenance', False)
    # if true - off it
    if current_status:
        LOG.info(f"Current status of Cluster maintenance mode is {current_status}")
        for machine in cluster.get_machines():
            LOG.info(f"Stop maintenance on Machine {machine.name}")
            machine.machine_maintenance_stop()
        cluster.check.check_machines_status()
        LOG.info(f"Stopping maintenance mode on Cluster {cluster.name}")
        cluster.cluster_maintenance_stop()
    # wait until ready
    cluster.check.check_machines_status()
    cluster.check.wait_cluster_maintenance_status(expected_status=False)
    cluster.check.check_cluster_readiness()


@pytest.fixture(scope='session')
def post_action_stop_mm_mode(request, kaas_manager):
    """Stop mm mode in cluster"""

    # Wait for test is finished first
    yield
    if request.session.testsfailed:
        cluster_name = settings.TARGET_CLUSTER
        namespace_name = settings.TARGET_NAMESPACE
        ns = kaas_manager.get_namespace(namespace_name)
        cluster = ns.get_cluster(cluster_name)
        _post_action_stop_mm_mode(cluster)
