#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFDbBackup(base.BaseModel):
    pass


class V1TFDbBackupList(base.BaseModelList):
    pass


class TFDbBackup(base.K8sNamespacedResource):
    resource_type = 'tfdbbackup'
    model = V1TFDbBackup


class TFDbBackupManager(base.K8sBaseManager):
    model = V1TFDbBackupList
    resource_class = TFDbBackup
    resource_group = 'tf-dbbackup.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfdbbackups'


class V2TFDbBackup(base.BaseModel):
    pass


class V2TFDbBackupList(base.BaseModelList):
    pass


class TFDbBackupV2(base.K8sNamespacedResource):
    resource_type = 'tfdbbackup'
    model = V2TFDbBackup


class TFDbBackupManagerV2(base.K8sBaseManager):
    model = V2TFDbBackupList
    resource_class = TFDbBackupV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfdbbackups'
