#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFConfig(base.BaseModel):
    pass


class V1TFConfigList(base.BaseModelList):
    pass


class TFConfig(base.K8sNamespacedResource):
    resource_type = 'tfconfig'
    model = V1TFConfig


class TFConfigManager(base.K8sBaseManager):
    model = V1TFConfigList
    resource_class = TFConfig
    resource_group = 'config.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfconfigs'


class V2TFConfig(base.BaseModel):
    pass


class V2TFConfigList(base.BaseModelList):
    pass


class TFConfigV2(base.K8sNamespacedResource):
    resource_type = 'tfconfig'
    model = V2TFConfig


class TFConfigManagerV2(base.K8sBaseManager):
    model = V2TFConfigList
    resource_class = TFConfigV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfconfigs'
