#    Copyright 2023 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSVsphereVMTemplate(base.BaseModel):
    pass


class V1KaaSVsphereVMTemplateList(base.BaseModelList):
    pass


class KaaSVsphereVMTemplate(base.K8sClusterScopedResource):
    resource_type = "vspherevmtemplate"
    model = V1KaaSVsphereVMTemplate

    @property
    def template_path(self) -> str:
        return self.data.get('status', {}).get('templatePath', '')

    @property
    def template_status(self) -> str:
        return self.data.get('status', {}).get('templateStatus', '')

    @property
    def build_status(self) -> str:
        return self.data.get('status', {}).get('buildStatus', {}).get('status', '')

    @property
    def is_template_present(self) -> bool:
        return self.template_status == "Present"

    @property
    def os_name(self) -> str:
        return self.data.get('spec', {}).get('packerImageOSName', '')

    @property
    def region(self) -> str:
        return self.data.get('metadata', {}).get('labels', {}).get('kaas.mirantis.com/region', '')


class KaaSVsphereVMTemplateManager(base.K8sBaseManager):
    model = V1KaaSVsphereVMTemplateList
    resource_class = KaaSVsphereVMTemplate
    resource_group = "kaas.mirantis.com"
    resource_version = "v1alpha1"
    resource_plural = "vspherevmtemplates"
