import pytest
from si_tests import logger, settings
from si_tests.managers.kaas_manager import Manager
from si_tests.utils.workload_report import BMWorkloadDowntimeReport, VMWorkloadDowntimeReport
from si_tests.deployments.deploy_workloads import PerNodeWorkload
from si_tests.managers.openstack_client_manager import OpenStackClientManager

LOG = logger.logger


def pytest_configure():
    pytest.workload_downtime_report_obj = None
    pytest.pernode_workload_obj = None


def pytest_sessionstart(session):
    """ Setup downtime report and workloads """
    if getattr(session.config, 'workerinput', None) is not None:
        # Inside worker process execution should be skipped, only inside master process it is allowed
        return
    if not settings.MOSK_WORKLOAD_DOWNTIME_REPORT:
        LOG.info("MOSK_WORKLOAD_DOWNTIME_REPORT is disabled, skipping workload downtime report")
        return
    # TODO(mkarpin): find out how to get test filename from session or request object
    func_name = session.config.args[0].split('/')[-1]
    release_key = 'mos'
    if settings.KUBECONFIG_MGMT_PATH:
        kubeconfig_path = settings.KUBECONFIG_MGMT_PATH
    else:
        kubeconfig_path = settings.KUBECONFIG_PATH
    kaas_manager = Manager(kubeconfig=kubeconfig_path)

    if kaas_manager.api.kaas_kaasreleases.available:
        ns = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
        child_cluster = ns.get_cluster(settings.TARGET_CLUSTER)
        report = BMWorkloadDowntimeReport(func_name, release_key, child_cluster)
    else:
        LOG.info(f"Kubeconfig {kubeconfig_path} is not a Management cluster config")
        report = VMWorkloadDowntimeReport(func_name, release_key)

    per_node_workload = PerNodeWorkload(OpenStackClientManager(kubeconfig=report.kubeconfig_file))
    per_node_workload.deploy()
    per_node_workload.check()

    report.set_up()
    pytest.workload_downtime_report_obj = report
    pytest.pernode_workload_obj = per_node_workload


def pytest_sessionfinish(session, exitstatus):
    """Dump downtime report and check/remove workloads"""
    if getattr(session.config, 'workerinput', None) is not None:
        # Inside worker process execution should be skipped, only inside master process it is allowed
        return
    if not settings.MOSK_WORKLOAD_DOWNTIME_REPORT:
        LOG.info("MOSK_WORKLOAD_DOWNTIME_REPORT is disabled, skipping workload downtime report")
        return
    report = pytest.workload_downtime_report_obj
    report.save()
    per_node_workload = pytest.pernode_workload_obj
    per_node_workload.ostcm.reload_client()
    per_node_workload.check()
    per_node_workload.delete()
