#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz7772]='HcdP3k8hb4mQX' \
[cz7773]='HcdP3k8hb4mQX' \
[cz7774]='HcdP3k8hb4mQX' \
[cz7328]='HcdP3k8hb4mQX' \
[cz7329]='HcdP3k8hb4mQX' \
[cz10161]='HcdP3k8hb4mQX' \
[cz7500]='KIgViw3T6b34' \
[cz7501]='KIgViw3T6b34' \
[cz7502]='KIgViw3T6b34' \
[cz7503]='KIgViw3T6b34' \
[cz7505]='KIgViw3T6b34' \
[cz7506]='KIgViw3T6b34' \
[cz5018]='SGtQMkZZZjVOcHpB' \
[cz5019]='SGtQMkZZZjVOcHpB' \
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz7328]='185.8.58.231' [cz7329]='185.8.58.232' \
               [cz10161]='5.43.229.193' [cz7500]='185.8.59.133' \
               [cz7501]='185.8.59.134' [cz7502]='185.8.59.135' \
               [cz7503]='185.8.59.136' [cz7505]='185.8.59.138' \
               [cz7506]='185.8.59.139' [cz5018]='176.74.216.112' \
	       [cz5019]='176.74.216.223')

  nodes_mgmt=([cz7772]='5.43.227.242' [cz7773]='185.8.59.24' \
              [cz7774]='185.8.59.208')
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action
    set +x
  done
 }

