from si_tests.deployments.utils import (extra_context, file_utils,
                                        wait_utils, commons, kubectl_utils)
from si_tests.deployments.utils.namespace import NAMESPACE
from si_tests import settings


def deploy_openstack_controller(os_manager, timeout):
    context = extra_context.ExtraContext().openstack_controller

    controller_yaml = file_utils.get_release("70-openstack-operator.yaml")
    controller_data = file_utils.get_yaml_content(controller_yaml)

    if context:
        commons.LOG.info("Update openstack operator context")
        image = context.get("image")
        chart = context.get("chart")
        spec = controller_data["spec"]
        if image:
            commons.LOG.info("Set operator image to %s", image)
            spec["releases"][0]["values"]["image"] = {"fullName": image}

        if chart:
            commons.LOG.info("Set operator chart to %s", chart)
            spec["repositories"][0]["url"] = chart["url"]
            spec["releases"][0]["version"] = chart["version"]

        if not context.get("addmission", True) \
                or settings.OPENSTACK_DEPLOY_OPENSTACK_VERSION == "master":
            commons.LOG.info("Disable admission")
            spec["releases"][0]["values"]["admission"] = {"enabled": False}

    new_yaml = file_utils.get_new_name(controller_yaml)
    commons.LOG.info("Save new operator yaml to %s", new_yaml)

    file_utils.save_to_yaml(controller_data, new_yaml)

    kubectl = kubectl_utils.Kubectl()
    commons.LOG.info("Deploy openstack controller")
    kubectl.apply(new_yaml)

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.osh)
    commons.LOG.info("Wait till openstack controller becomes healthy")
    wait.deployment(os_manager.oc_name)
    commons.LOG.info("OpenStack controller deployed successfully")
