#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base
from si_tests.utils import utils


class V1K0rdentRelease(base.BaseModel):
    pass


class V1K0rdentReleaseList(base.BaseModelList):
    pass


class K0rdentRelease(base.K8sClusterScopedResource):
    resource_type = 'release'
    model = V1K0rdentRelease

    @property
    def version(self):
        return self.data.get('spec', {}).get('version', None)

    @property
    def is_dev(self):
        return utils.is_version_dev(self.version)

    @property
    def is_enterprise(self):
        # note: actually checks by name, not by version
        return utils.is_version_enterprise(self.name)


class K0rdentReleaseManager(base.K8sBaseManager):
    model = V1K0rdentReleaseList
    resource_class = K0rdentRelease
    resource_group = 'k0rdent.mirantis.com'
    resource_version = 'v1beta1'
    resource_plural = 'releases'
