# si_tests.clients.gcore.box_api.UserGroupsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_group**](UserGroupsApi.md#v1_create_group) | **POST** /v1/admin/groups | Create user group
[**v1_delete_group**](UserGroupsApi.md#v1_delete_group) | **DELETE** /v1/admin/groups/{group_name} | Delete user group
[**v1_get_group**](UserGroupsApi.md#v1_get_group) | **GET** /v1/admin/groups/{group_name} | Get user group
[**v1_groups_list**](UserGroupsApi.md#v1_groups_list) | **GET** /v1/users/me/groups | Get current user&#39;s groups
[**v1_list_groups**](UserGroupsApi.md#v1_list_groups) | **GET** /v1/admin/groups | List user groups
[**v1_replace_group**](UserGroupsApi.md#v1_replace_group) | **PUT** /v1/admin/groups/{group_name} | Replace user group


# **v1_create_group**
> V1GroupResponse v1_create_group(v1_create_group_request)

Create user group

This endpoint creates a new user group with the specified properties.

User groups allow you to manage access permissions for multiple users at once.
When creating a user group, you can define:
- Access rules for different projects
- Whether the group has superuser privileges

Users can then be assigned to these groups to inherit their permissions.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_group_request import V1CreateGroupRequest
from si_tests.clients.gcore.box_api.models.v1_group_response import V1GroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UserGroupsApi(api_client)
    v1_create_group_request = si_tests.clients.gcore.box_api.V1CreateGroupRequest() # V1CreateGroupRequest | Group body

    try:
        # Create user group
        api_response = api_instance.v1_create_group(v1_create_group_request)
        print("The response of UserGroupsApi->v1_create_group:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UserGroupsApi->v1_create_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_group_request** | [**V1CreateGroupRequest**](V1CreateGroupRequest.md)| Group body | 

### Return type

[**V1GroupResponse**](V1GroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_group**
> v1_delete_group(group_name)

Delete user group

This endpoint removes a user group from the system.

When a user group is deleted:
- The group's access permissions are no longer applied to any users
- Users who were members of the group will retain their individual permissions
and memberships in other groups
- The group will no longer appear in the list of available user groups

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UserGroupsApi(api_client)
    group_name = 'group_name_example' # str | Group name

    try:
        # Delete user group
        api_instance.v1_delete_group(group_name)
    except Exception as e:
        print("Exception when calling UserGroupsApi->v1_delete_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_name** | **str**| Group name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_group**
> V1GroupResponse v1_get_group(group_name)

Get user group

This endpoint retrieves detailed information about a specific user group by name.

The response includes:
- The group's name
- Access rules defining permissions for different projects
- Whether the group has superuser privileges
- When the group was created

Use this endpoint when you need to examine the configuration of a particular user group
or verify its access permissions.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_group_response import V1GroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UserGroupsApi(api_client)
    group_name = 'group_name_example' # str | Group name

    try:
        # Get user group
        api_response = api_instance.v1_get_group(group_name)
        print("The response of UserGroupsApi->v1_get_group:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UserGroupsApi->v1_get_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_name** | **str**| Group name | 

### Return type

[**V1GroupResponse**](V1GroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_groups_list**
> V1ListGroupResponse v1_groups_list()

Get current user's groups

This endpoint retrieves information about the currently authenticated user.

The response includes:
- Groups detailed info
Use this endpoint when you need to:
- Display user's groups

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_group_response import V1ListGroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UserGroupsApi(api_client)

    try:
        # Get current user's groups
        api_response = api_instance.v1_groups_list()
        print("The response of UserGroupsApi->v1_groups_list:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UserGroupsApi->v1_groups_list: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListGroupResponse**](V1ListGroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_groups**
> V1ListGroupResponse v1_list_groups()

List user groups

This endpoint retrieves a list of all user groups in the system.

User groups are collections of users with shared access permissions.
Use this endpoint to get an overview of all available user groups and their configurations.
This information is useful for user management and access control planning.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_group_response import V1ListGroupResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UserGroupsApi(api_client)

    try:
        # List user groups
        api_response = api_instance.v1_list_groups()
        print("The response of UserGroupsApi->v1_list_groups:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UserGroupsApi->v1_list_groups: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListGroupResponse**](V1ListGroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_replace_group**
> V1GroupResponse v1_replace_group(group_name, v1_update_group_request)

Replace user group

This endpoint updates an existing user group's properties.

You can modify:
- Access rules for different projects
- Whether the group has superuser privileges

Use this endpoint when you need to:
- Change the permissions assigned to a group of users
- Grant or revoke superuser privileges for a group
- Update project access rules

Note: The group name cannot be changed using this endpoint.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_group_response import V1GroupResponse
from si_tests.clients.gcore.box_api.models.v1_update_group_request import V1UpdateGroupRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UserGroupsApi(api_client)
    group_name = 'group_name_example' # str | Group name
    v1_update_group_request = si_tests.clients.gcore.box_api.V1UpdateGroupRequest() # V1UpdateGroupRequest | Group body

    try:
        # Replace user group
        api_response = api_instance.v1_replace_group(group_name, v1_update_group_request)
        print("The response of UserGroupsApi->v1_replace_group:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UserGroupsApi->v1_replace_group: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_name** | **str**| Group name | 
 **v1_update_group_request** | [**V1UpdateGroupRequest**](V1UpdateGroupRequest.md)| Group body | 

### Return type

[**V1GroupResponse**](V1GroupResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

