# si_tests.clients.gcore.box_api.SlurmApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_slurm_cluster**](SlurmApi.md#v1_create_slurm_cluster) | **POST** /v1/{project_name}/slurm/clusters | Create Slurm cluster
[**v1_delete_slurm_cluster**](SlurmApi.md#v1_delete_slurm_cluster) | **DELETE** /v1/{project_name}/slurm/clusters/{region_name} | Delete Slurm cluster
[**v1_get_slurm_cluster**](SlurmApi.md#v1_get_slurm_cluster) | **GET** /v1/{project_name}/slurm/clusters/{region_name} | Get Slurm cluster
[**v1_list_slurm_clusters**](SlurmApi.md#v1_list_slurm_clusters) | **GET** /v1/{project_name}/slurm/clusters | List Slurm clusters
[**v1_update_slurm_cluster**](SlurmApi.md#v1_update_slurm_cluster) | **PATCH** /v1/{project_name}/slurm/clusters/{region_name} | Update Slurm cluster


# **v1_create_slurm_cluster**
> V1SlurmClusterResponse v1_create_slurm_cluster(project_name, v1_create_slurm_cluster_request)

Create Slurm cluster

This endpoint creates a new Slurm cluster in the specified region within your project.

Slurm is an open source workload manager and job scheduler for Linux clusters.
It provides job scheduling, resource allocation, and cluster management capabilities
for batch processing and parallel computing workloads. Our platform uses the soperator
(Slurm Operator) to manage Slurm clusters in Kubernetes environments.

Important limitations and requirements:
- Only one Slurm cluster per region can be created in a project
- Each cluster is identified by its region name rather than a separate cluster name
- This limitation comes from soperator requiring the SlurmCluster resource name to equal the Kubernetes namespace name
- Only core regions are supported for Slurm cluster deployments

Use this endpoint when you need to:
- Set up a new high-performance computing environment for batch jobs
- Create a dedicated cluster for machine learning training workloads
- Establish a Slurm environment in a new region for your project

The created cluster will include essential Slurm components like the login nodes, controller nodes,
and worker nodes, all managed by the soperator.

Note: The creation process may take several minutes to complete as the cluster components
are provisioned and configured.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_request import V1CreateSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SlurmApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_slurm_cluster_request = si_tests.clients.gcore.box_api.V1CreateSlurmClusterRequest() # V1CreateSlurmClusterRequest | Slurm cluster configuration

    try:
        # Create Slurm cluster
        api_response = api_instance.v1_create_slurm_cluster(project_name, v1_create_slurm_cluster_request)
        print("The response of SlurmApi->v1_create_slurm_cluster:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SlurmApi->v1_create_slurm_cluster: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_slurm_cluster_request** | [**V1CreateSlurmClusterRequest**](V1CreateSlurmClusterRequest.md)| Slurm cluster configuration | 

### Return type

[**V1SlurmClusterResponse**](V1SlurmClusterResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_slurm_cluster**
> v1_delete_slurm_cluster(project_name, region_name)

Delete Slurm cluster

This endpoint permanently removes a Slurm cluster and all its associated resources
from the specified region.

Slurm (Simple Linux Utility for Resource Management) is a workload manager and job scheduler
for Linux clusters. It provides job scheduling, resource allocation, and cluster management
capabilities for batch processing and parallel computing workloads. Our platform uses the soperator
(Slurm Operator) to manage Slurm clusters in Kubernetes environments.

When you delete a Slurm cluster:
- All running and queued jobs are terminated immediately
- All cluster data and job history are permanently deleted
- All resources associated with the cluster are released
- The cluster is removed from the specified region

Use this endpoint when you need to:
- Remove a Slurm cluster that is no longer needed
- Free up compute resources and reduce costs
- Clean up unused or obsolete cluster deployments
- Decommission a cluster after completing your computational work

Warning: This operation cannot be undone. Ensure you have backed up any important data
and that no critical jobs are running before deleting the cluster.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SlurmApi(api_client)
    project_name = 'project_name_example' # str | Project name
    region_name = 'region_name_example' # str | Region name

    try:
        # Delete Slurm cluster
        api_instance.v1_delete_slurm_cluster(project_name, region_name)
    except Exception as e:
        print("Exception when calling SlurmApi->v1_delete_slurm_cluster: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **region_name** | **str**| Region name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_slurm_cluster**
> V1SlurmClusterResponse v1_get_slurm_cluster(project_name, region_name)

Get Slurm cluster

This endpoint retrieves detailed information about a specific Slurm cluster in the given region.

Slurm is an open source workload manager and job scheduler for Linux clusters.
It provides job scheduling, resource allocation, and cluster management capabilities
for batch processing and parallel computing workloads. Our platform uses the soperator
(Slurm Operator) to manage Slurm clusters in Kubernetes environments.

The response includes:
- Cluster configuration details (region, creation time, status)
- Login node configuration including SSH access details and authorized keys
- Worker node configuration including flavor, size, and storage volume
- Current cluster status and operational information

Use this endpoint when you need to:
- Get detailed information about a specific Slurm cluster
- Check the current status and configuration of your cluster
- Retrieve SSH connection details for login nodes
- View worker node specifications and resource allocations

Note: Since only one Slurm cluster per region can exist in a project (due to soperator
requirements), this endpoint effectively returns the cluster for the specified region if it exists.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SlurmApi(api_client)
    project_name = 'project_name_example' # str | Project name
    region_name = 'region_name_example' # str | Region name

    try:
        # Get Slurm cluster
        api_response = api_instance.v1_get_slurm_cluster(project_name, region_name)
        print("The response of SlurmApi->v1_get_slurm_cluster:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SlurmApi->v1_get_slurm_cluster: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **region_name** | **str**| Region name | 

### Return type

[**V1SlurmClusterResponse**](V1SlurmClusterResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_slurm_clusters**
> V1ListSlurmClustersResponse v1_list_slurm_clusters(project_name)

List Slurm clusters

This endpoint retrieves all Slurm clusters in the project across all regions.

Slurm is an open source workload manager and job scheduler for Linux clusters.
It provides job scheduling, resource allocation, and cluster management capabilities
for batch processing and parallel computing workloads. Our platform uses the soperator
(Slurm Operator) to manage Slurm clusters in Kubernetes environments.

Use this endpoint when you need to:
- Get an overview of all Slurm clusters in your project
- Monitor the status of your clusters across regions
- View cluster configurations and resource allocations

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_slurm_clusters_response import V1ListSlurmClustersResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SlurmApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List Slurm clusters
        api_response = api_instance.v1_list_slurm_clusters(project_name)
        print("The response of SlurmApi->v1_list_slurm_clusters:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SlurmApi->v1_list_slurm_clusters: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListSlurmClustersResponse**](V1ListSlurmClustersResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_slurm_cluster**
> V1SlurmClusterResponse v1_update_slurm_cluster(project_name, region_name, v1_patch_slurm_cluster_request)

Update Slurm cluster

This endpoint allows you to modify the configuration of an existing Slurm cluster.

Slurm is an open source workload manager and job scheduler for Linux clusters.
It provides job scheduling, resource allocation, and cluster management capabilities
for batch processing and parallel computing workloads. Our platform uses the soperator
(Slurm Operator) to manage Slurm clusters in Kubernetes environments.

Use this endpoint when you need to:
- Scale your cluster up to handle increased workload
- Scale your cluster down to reduce resource usage and costs

Note: The system will validate that sufficient capacity exists for scaling up.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_request import V1PatchSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.SlurmApi(api_client)
    project_name = 'project_name_example' # str | Project name
    region_name = 'region_name_example' # str | Region name
    v1_patch_slurm_cluster_request = si_tests.clients.gcore.box_api.V1PatchSlurmClusterRequest() # V1PatchSlurmClusterRequest | Update Slurm cluster configuration

    try:
        # Update Slurm cluster
        api_response = api_instance.v1_update_slurm_cluster(project_name, region_name, v1_patch_slurm_cluster_request)
        print("The response of SlurmApi->v1_update_slurm_cluster:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SlurmApi->v1_update_slurm_cluster: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **region_name** | **str**| Region name | 
 **v1_patch_slurm_cluster_request** | [**V1PatchSlurmClusterRequest**](V1PatchSlurmClusterRequest.md)| Update Slurm cluster configuration | 

### Return type

[**V1SlurmClusterResponse**](V1SlurmClusterResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

