# ServiceTemplates test module

## Overview
This directory contains tests related to ServiceTemplates

## Test Suite
- [Create a ServiceTemplate in the specified namespace](#test_add_servicetemplatepy)
- [Create and apply a ServiceTemplate to the specified cluster](#test_servicetemplatepy)
- [Add extra services into existing ClusterDeployment](#add-extra-services-into-existing-clusterdeployment-test_add_service_to_clusterdeploymentpy)
- [Check that servicetemplate can be applied to cluster](#check-that-servicetemplate-can-be-applied-to-cluster-test_servicetemplates_actionspy)

## Pre-requisites

- Working k0rdent kcm installation required to execute any of those tests

## Existing tests and requirements

### test_add_servicetemplate.py
Add ServiceTemplate object into the specified Namespace, to create a ClusterDeployment with a predefined service from this ServiceTemplate.

#### Variables that MUST be filled before run and have no default value
| ENV Variable                                   | Type    | Desctiption                                                                                 |
|------------------------------------------------|---------|---------------------------------------------------------------------------------------------|
| `CUSTOM_SERVICETEMPLATE_PATH`                  | `<str>` | YAML template in Jinja2 format to create a ServiceTemplate object                           |

#### Example of environment variables for the template `CUSTOM_SERVICETEMPLATE_PATH=si_tests/templates/deploy-objects/servicetemplates/default/servicetemplate.yaml`
| ENV Variable                               | Type    | Desctiption                                                                          | Defaults          |
|--------------------------------------------|---------|--------------------------------------------------------------------------------------|-------------------|
| `SERVICETEMPLATE_NAME`                     | `<str>` | Name of the creating ServiceTemplate object                                          | ''                |
| `SERVICETEMPLATE_NAMESPACE`                | `<str>` | Namespace where to create the ServiceTemplate                                        | 'kcm-system'      |
| `SERVICETEMPLATE_CHART_NAME`               | `<str>` | Chart name for the ServiceTemplate  (application to deploy as a service)             | ''                |
| `SERVICETEMPLATE_CHART_VERSION`            | `<str>` | Chart version for the ServiceTemplate                                                | ''                |
| `SERVICETEMPLATE_CHART_INTERVAL`           | `<str>` | Chart pull interval                                                                  | '10m0s'           |
| `SERVICETEMPLATE_HELM_REPOSITORY_NAME`     | `<str>` | Repository name, where to lookup for the specified Chart                             | ''                |
| `SERVICETEMPLATE_HELM_REPOSITORY_KIND`     | `<str>` | Repository kind (HelmRepository, GitRepository)                                      | 'HelmRepository'  |
| `SERVICETEMPLATE_CHART_VALUESFILES`        | `<str>` | comma-separated list of files to get default values from the chart                   | 'values.yaml'     |

### test_servicetemplate.py
Create a new ServiceTemplate and add a new `service` into existing ClusterDeployment using this ServiceTemplate

#### Variables that MUST be filled before run and have no default value
| ENV Variable                                 | Type    | Desctiption                                                                                 |
|----------------------------------------------|---------|---------------------------------------------------------------------------------------------|
| `TARGET_CLD`                                 | `<str>` | Target clusterdeployment name                                                               |
| `TARGET_NAMESPACE`                           | `<str>` | Target clusterdeployment namespace                                                          |
| `CUSTOM_SERVICETEMPLATE_PATH`                | `<str>` | YAML template in Jinja2 format to create a ServiceTemplate object                           |
| `KCM_SERVICE_TEMPLATE_NAME`                  | `<str>` | (optional) Existing ServiceTemplate object name, if CUSTOM_SERVICETEMPLATE_PATH not set     |

#### Optional variables to customise the service deployment
| ENV Variable                                 | Type    | Desctiption                                                                                                                      | Defaults   |
|----------------------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------|------------|
| `CUSTOM_CLUSTERSERVICE_NAME`                 | `<str>` | ClusterDeployment service `name` of the projectSveltos service                                                                   | ''         |
| `CUSTOM_CLUSTERSERVICE_NAMESPACE`            | `<str>` | ClusterDeployment service `namespace`, which will be used to deploy the service on the target cluster                            | ''         |
| `CUSTOM_SERVICETEMPLATE_VALUES_PATH`         | `<str>` | Extra values for the service chart, in YAML format. Will be used to create a ConfigMap to use in the ClusterDeployment service   | ''         |

#### Example of environment variables for the template `CUSTOM_SERVICETEMPLATE_PATH=si_tests/templates/deploy-objects/servicetemplates/default/servicetemplate.yaml`
| ENV Variable                               | Type    | Desctiption                                                                          | Defaults          |
|--------------------------------------------|---------|--------------------------------------------------------------------------------------|-------------------|
| `SERVICETEMPLATE_NAME`                     | `<str>` | Name of the creating ServiceTemplate object                                          | ''                |
| `SERVICETEMPLATE_NAMESPACE`                | `<str>` | Namespace where to create the ServiceTemplate                                        | 'kcm-system'      |
| `SERVICETEMPLATE_CHART_NAME`               | `<str>` | Chart name for the ServiceTemplate  (application to deploy as a service)             | ''                |
| `SERVICETEMPLATE_CHART_VERSION`            | `<str>` | Chart version for the ServiceTemplate                                                | ''                |
| `SERVICETEMPLATE_CHART_INTERVAL`           | `<str>` | Chart pull interval                                                                  | '10m0s'           |
| `SERVICETEMPLATE_HELM_REPOSITORY_NAME`     | `<str>` | Repository name, where to lookup for the specified Chart                             | ''                |
| `SERVICETEMPLATE_HELM_REPOSITORY_KIND`     | `<str>` | Repository kind (HelmRepository, GitRepository)                                      | 'HelmRepository'  |
| `SERVICETEMPLATE_CHART_VALUESFILES`        | `<str>` | comma-separated list of files to get default values from the chart                   | 'values.yaml'     |

## Add extra services into existing ClusterDeployment (test_add_service_to_clusterdeployment.py)
Test to add extra ClusterDeployment services using a pre-defined file with the services details.

#### Variables that MUST be filled before run and have no default value
| ENV Variable                             | Type    | Desctiption                                                                      |
|------------------------------------------|---------|----------------------------------------------------------------------------------|
| `TARGET_CLD`                             | `<str>` | Target clusterdeployment name                                                    |
| `TARGET_NAMESPACE`                       | `<str>` | Target clusterdeployment namespace                                               |
| `CUSTOM_CLUSTERDEPLOYMENT_SERVICES_PATH` | `<str>` | Path to the ClusterDeployment services yaml file (will be rendered using Jinja2) |

### Check that servicetemplate can be applied to cluster (test_servicetemplates_actions.py)

Check that servicetemplate can be applied to cluster

#### Variables that MUST be filled before run and have no default value
| ENV Variable                                 | Type    | Desctiption                                                                                 |
|----------------------------------------------|---------|---------------------------------------------------------------------------------------------|
| `SERVICE_TEMPLATE_NAME_LIST`                  | `<str>` | List of Existing ServiceTemplate objects|
| `TARGET_CLD`                                 | `<str>` | Target clusterdeployment name                                                               |
| `TARGET_NAMESPACE`                           | `<str>` | Target clusterdeployment namespace                                                          |
