# V1ContainerProbe


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**var_exec** | [**V1ExecProbe**](V1ExecProbe.md) |  | [optional] 
**failure_threshold** | **int** | FailureThreshold After a probe fails failureThreshold times in a row, Kubernetes considers that the overall check has failed: the container is not ready/healthy/live. | [optional] 
**http_get** | [**V1HttpGetProbe**](V1HttpGetProbe.md) |  | [optional] 
**initial_delay_seconds** | **int** | InitialDelaySeconds Number of seconds after the container has started before startup, liveness or readiness probes are initiated. | [optional] 
**period_seconds** | **int** | PeriodSeconds How often (in seconds) to perform the probe. | [optional] 
**success_threshold** | **int** | SuccessThreshold Minimum consecutive successes for the probe to be considered successful after having failed. | [optional] 
**tcp_socket** | [**V1TcpSocketProbe**](V1TcpSocketProbe.md) |  | [optional] 
**timeout_seconds** | **int** | TimeoutSeconds Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_container_probe import V1ContainerProbe

# TODO update the JSON string below
json = "{}"
# create an instance of V1ContainerProbe from a JSON string
v1_container_probe_instance = V1ContainerProbe.from_json(json)
# print the JSON string representation of the object
print(V1ContainerProbe.to_json())

# convert the object into a dict
v1_container_probe_dict = v1_container_probe_instance.to_dict()
# create an instance of V1ContainerProbe from a dict
v1_container_probe_from_dict = V1ContainerProbe.from_dict(v1_container_probe_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


