# si_tests.clients.gcore.box_api.TLSSecretsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_tls_secret**](TLSSecretsApi.md#v1_create_tls_secret) | **POST** /v1/{project_name}/tlssecrets | Create tls secret
[**v1_delete_tls_secret**](TLSSecretsApi.md#v1_delete_tls_secret) | **DELETE** /v1/{project_name}/tlssecrets/{secret_name} | Delete tls secret
[**v1_get_tls_secret**](TLSSecretsApi.md#v1_get_tls_secret) | **GET** /v1/{project_name}/tlssecrets/{secret_name} | Get tls secret
[**v1_list_tls_secrets**](TLSSecretsApi.md#v1_list_tls_secrets) | **GET** /v1/{project_name}/tlssecrets | List tls secrets
[**v1_update_tls_secret**](TLSSecretsApi.md#v1_update_tls_secret) | **PATCH** /v1/{project_name}/tlssecrets/{secret_name} | Update tls secret


# **v1_create_tls_secret**
> V1TlsSecretResponse v1_create_tls_secret(project_name, v1_create_tls_secret_request)

Create tls secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_tls_secret_request import V1CreateTlsSecretRequest
from si_tests.clients.gcore.box_api.models.v1_tls_secret_response import V1TlsSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.TLSSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_tls_secret_request = si_tests.clients.gcore.box_api.V1CreateTlsSecretRequest() # V1CreateTlsSecretRequest | Secret body

    try:
        # Create tls secret
        api_response = api_instance.v1_create_tls_secret(project_name, v1_create_tls_secret_request)
        print("The response of TLSSecretsApi->v1_create_tls_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TLSSecretsApi->v1_create_tls_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_tls_secret_request** | [**V1CreateTlsSecretRequest**](V1CreateTlsSecretRequest.md)| Secret body | 

### Return type

[**V1TlsSecretResponse**](V1TlsSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created |  -  |
**400** | Bad Request |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_tls_secret**
> v1_delete_tls_secret(project_name, secret_name)

Delete tls secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.TLSSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    secret_name = 'secret_name_example' # str | Secret name

    try:
        # Delete tls secret
        api_instance.v1_delete_tls_secret(project_name, secret_name)
    except Exception as e:
        print("Exception when calling TLSSecretsApi->v1_delete_tls_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **secret_name** | **str**| Secret name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_tls_secret**
> V1TlsSecretResponse v1_get_tls_secret(project_name, secret_name)

Get tls secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_tls_secret_response import V1TlsSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.TLSSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    secret_name = 'secret_name_example' # str | Secret name

    try:
        # Get tls secret
        api_response = api_instance.v1_get_tls_secret(project_name, secret_name)
        print("The response of TLSSecretsApi->v1_get_tls_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TLSSecretsApi->v1_get_tls_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **secret_name** | **str**| Secret name | 

### Return type

[**V1TlsSecretResponse**](V1TlsSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_tls_secrets**
> V1ListTlsSecretResponse v1_list_tls_secrets(project_name)

List tls secrets

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_tls_secret_response import V1ListTlsSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.TLSSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List tls secrets
        api_response = api_instance.v1_list_tls_secrets(project_name)
        print("The response of TLSSecretsApi->v1_list_tls_secrets:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TLSSecretsApi->v1_list_tls_secrets: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListTlsSecretResponse**](V1ListTlsSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_tls_secret**
> V1TlsSecretResponse v1_update_tls_secret(project_name, secret_name, v1_update_tls_secret_request)

Update tls secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_tls_secret_response import V1TlsSecretResponse
from si_tests.clients.gcore.box_api.models.v1_update_tls_secret_request import V1UpdateTlsSecretRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.TLSSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    secret_name = 'secret_name_example' # str | Secret name
    v1_update_tls_secret_request = si_tests.clients.gcore.box_api.V1UpdateTlsSecretRequest() # V1UpdateTlsSecretRequest | Secret body

    try:
        # Update tls secret
        api_response = api_instance.v1_update_tls_secret(project_name, secret_name, v1_update_tls_secret_request)
        print("The response of TLSSecretsApi->v1_update_tls_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TLSSecretsApi->v1_update_tls_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **secret_name** | **str**| Secret name | 
 **v1_update_tls_secret_request** | [**V1UpdateTlsSecretRequest**](V1UpdateTlsSecretRequest.md)| Secret body | 

### Return type

[**V1TlsSecretResponse**](V1TlsSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

