# si_tests.clients.gcore.box_api.MetricsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_get_raw_metrics**](MetricsApi.md#v1_get_raw_metrics) | **GET** /v1/{project_name}/metrics | Return raw metrics
[**v1_query_metrics**](MetricsApi.md#v1_query_metrics) | **GET** /v1/{project_name}/metrics/query | Execute an instant query for metrics
[**v1_query_range_metrics**](MetricsApi.md#v1_query_range_metrics) | **GET** /v1/{project_name}/metrics/query_range | Execute a range query for metrics


# **v1_get_raw_metrics**
> str v1_get_raw_metrics(project_name)

Return raw metrics

Returns raw metrics data in Prometheus format for the specified project. This endpoint is useful for monitoring tools that can consume Prometheus metrics directly.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.MetricsApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # Return raw metrics
        api_response = api_instance.v1_get_raw_metrics(project_name)
        print("The response of MetricsApi->v1_get_raw_metrics:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling MetricsApi->v1_get_raw_metrics: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/openmetrics-text; version=1.0.0; charset=utf-8, text/plain; version=0.0.4, application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_query_metrics**
> V1MetricsQueryResponse v1_query_metrics(project_name, query, time=time, timeout=timeout, limit=limit, inference=inference)

Execute an instant query for metrics

Executes a Prometheus query at a single point in time. This endpoint allows you to retrieve metrics data using PromQL (Prometheus Query Language) expressions. You can filter the results by inference name and specify evaluation time and timeout.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_metrics_query_response import V1MetricsQueryResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.MetricsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    query = 'query_example' # str | PromQL expression to evaluate. Required. Example: `sum(rate(container_cpu_usage_seconds_total[5m]))`. Supported metrics: `container_cpu_usage_seconds_total`, `container_memory_working_set_bytes`, `container_fs_io_current`, `DCGM_FI_DEV_GPU_UTIL`, `DCGM_FI_DEV_MEM_COPY_UTIL`. Also supported metrics prefixed with llamacpp:, nv_inference_, nv_trt_llm_, slurm_, sglang:, and vllm:. Currently supported only Vector and Matrix results, Scalar and String results are not supported.
    time = 'time_example' # str | Evaluation timestamp in RFC-3339 format or unix timestamp. Optional. (optional)
    timeout = 'timeout_example' # str | Evaluation timeout in duration format. Optional. (optional)
    limit = 56 # int | Maximum number of returned series. Optional. 0 means disabled (optional)
    inference = 'inference_example' # str | Inference name filter. Optional. Defaults to all inference deployments within a namespace. (optional)

    try:
        # Execute an instant query for metrics
        api_response = api_instance.v1_query_metrics(project_name, query, time=time, timeout=timeout, limit=limit, inference=inference)
        print("The response of MetricsApi->v1_query_metrics:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling MetricsApi->v1_query_metrics: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **query** | **str**| PromQL expression to evaluate. Required. Example: &#x60;sum(rate(container_cpu_usage_seconds_total[5m]))&#x60;. Supported metrics: &#x60;container_cpu_usage_seconds_total&#x60;, &#x60;container_memory_working_set_bytes&#x60;, &#x60;container_fs_io_current&#x60;, &#x60;DCGM_FI_DEV_GPU_UTIL&#x60;, &#x60;DCGM_FI_DEV_MEM_COPY_UTIL&#x60;. Also supported metrics prefixed with llamacpp:, nv_inference_, nv_trt_llm_, slurm_, sglang:, and vllm:. Currently supported only Vector and Matrix results, Scalar and String results are not supported. | 
 **time** | **str**| Evaluation timestamp in RFC-3339 format or unix timestamp. Optional. | [optional] 
 **timeout** | **str**| Evaluation timeout in duration format. Optional. | [optional] 
 **limit** | **int**| Maximum number of returned series. Optional. 0 means disabled | [optional] 
 **inference** | **str**| Inference name filter. Optional. Defaults to all inference deployments within a namespace. | [optional] 

### Return type

[**V1MetricsQueryResponse**](V1MetricsQueryResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_query_range_metrics**
> V1MetricsQueryResponse v1_query_range_metrics(project_name, start, end, step, query, timeout=timeout, limit=limit, inference=inference)

Execute a range query for metrics

Executes a Prometheus query over a range of time. This endpoint allows you to retrieve time series data using PromQL (Prometheus Query Language) expressions. You can specify the start and end times, step interval, and filter the results by inference name.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_metrics_query_response import V1MetricsQueryResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.MetricsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    start = 'start_example' # str | Start timestamp in RFC-3339 format or unix timestamp, inclusive.
    end = 'end_example' # str | End timestamp in RFC-3339 format or unix timestamp, inclusive.
    step = 'step_example' # str | Query resolution step width in duration format or float number of seconds.
    query = 'query_example' # str | PromQL expression to evaluate. Required. Example: `sum(rate(container_cpu_usage_seconds_total[5m]))`. Supported metrics: `container_cpu_usage_seconds_total`, `container_memory_working_set_bytes`, `container_fs_io_current`, `DCGM_FI_DEV_GPU_UTIL`, `DCGM_FI_DEV_MEM_COPY_UTIL`. Also supported metrics prefixed with llamacpp:, nv_inference_, nv_trt_llm_, slurm_, sglang:, and vllm:. Currently supported only Vector and Matrix results, Scalar and String results are not supported.
    timeout = 'timeout_example' # str | Evaluation timeout in duration format. Optional. (optional)
    limit = 56 # int | Maximum number of returned series. Optional. 0 means disabled (optional)
    inference = 'inference_example' # str | Inference name filter. Optional. Defaults to all inference deployments within a namespace. (optional)

    try:
        # Execute a range query for metrics
        api_response = api_instance.v1_query_range_metrics(project_name, start, end, step, query, timeout=timeout, limit=limit, inference=inference)
        print("The response of MetricsApi->v1_query_range_metrics:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling MetricsApi->v1_query_range_metrics: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **start** | **str**| Start timestamp in RFC-3339 format or unix timestamp, inclusive. | 
 **end** | **str**| End timestamp in RFC-3339 format or unix timestamp, inclusive. | 
 **step** | **str**| Query resolution step width in duration format or float number of seconds. | 
 **query** | **str**| PromQL expression to evaluate. Required. Example: &#x60;sum(rate(container_cpu_usage_seconds_total[5m]))&#x60;. Supported metrics: &#x60;container_cpu_usage_seconds_total&#x60;, &#x60;container_memory_working_set_bytes&#x60;, &#x60;container_fs_io_current&#x60;, &#x60;DCGM_FI_DEV_GPU_UTIL&#x60;, &#x60;DCGM_FI_DEV_MEM_COPY_UTIL&#x60;. Also supported metrics prefixed with llamacpp:, nv_inference_, nv_trt_llm_, slurm_, sglang:, and vllm:. Currently supported only Vector and Matrix results, Scalar and String results are not supported. | 
 **timeout** | **str**| Evaluation timeout in duration format. Optional. | [optional] 
 **limit** | **int**| Maximum number of returned series. Optional. 0 means disabled | [optional] 
 **inference** | **str**| Inference name filter. Optional. Defaults to all inference deployments within a namespace. | [optional] 

### Return type

[**V1MetricsQueryResponse**](V1MetricsQueryResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

