# si_tests.clients.gcore.box_api.AuditLogsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_query_audit_log**](AuditLogsApi.md#v1_query_audit_log) | **GET** /v1/admin/audit-logs | Execute an instant query for audit log


# **v1_query_audit_log**
> V1AuditLogsResponse v1_query_audit_log(start=start, end=end, limit=limit, resource=resource, project=project, verb=verb, user=user, group=group)

Execute an instant query for audit log

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_audit_logs_response import V1AuditLogsResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AuditLogsApi(api_client)
    start = 'start_example' # str | Evaluation start timestamp in RFC-3339 format. example:2025-06-01T00:00:00Z (optional)
    end = 'end_example' # str | Evaluation end timestamp in RFC-3339 format. example:2025-06-01T23:59:59Z (optional)
    limit = 56 # int | Maximum number of returned records. example:100 (optional)
    resource = 'resource_example' # str | List of resources. Allowed values: inferences, volumes, externalsecrets, flavors, users, namespaces, registries, rbacdefinitions, images, usersgroups, nodegroups, mlappdeployments, resourcequotas. example:inferences,volumes (optional)
    project = 'project_example' # str | List of projects. example:my-namespace,my-second-namespace (optional)
    verb = 'verb_example' # str | List of verbs. Allowed values:'create, delete, update, get, list, patch. example: create,delete (optional)
    user = 'user_example' # str | List of users. example:bilbo-baggins,inference.superuser (optional)
    group = 'group_example' # str | List of user groups. example: hobbits (optional)

    try:
        # Execute an instant query for audit log
        api_response = api_instance.v1_query_audit_log(start=start, end=end, limit=limit, resource=resource, project=project, verb=verb, user=user, group=group)
        print("The response of AuditLogsApi->v1_query_audit_log:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AuditLogsApi->v1_query_audit_log: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **start** | **str**| Evaluation start timestamp in RFC-3339 format. example:2025-06-01T00:00:00Z | [optional] 
 **end** | **str**| Evaluation end timestamp in RFC-3339 format. example:2025-06-01T23:59:59Z | [optional] 
 **limit** | **int**| Maximum number of returned records. example:100 | [optional] 
 **resource** | **str**| List of resources. Allowed values: inferences, volumes, externalsecrets, flavors, users, namespaces, registries, rbacdefinitions, images, usersgroups, nodegroups, mlappdeployments, resourcequotas. example:inferences,volumes | [optional] 
 **project** | **str**| List of projects. example:my-namespace,my-second-namespace | [optional] 
 **verb** | **str**| List of verbs. Allowed values:&#39;create, delete, update, get, list, patch. example: create,delete | [optional] 
 **user** | **str**| List of users. example:bilbo-baggins,inference.superuser | [optional] 
 **group** | **str**| List of user groups. example: hobbits | [optional] 

### Return type

[**V1AuditLogsResponse**](V1AuditLogsResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

