from si_tests import settings, logger
from si_tests.managers import bootstrap_manager
from si_tests.managers import pdns_manager

LOG = logger.logger


def test_install_pdns_on_seed_node():
    """Install PDNS Authoritative server and Recursor services on seed node

    - Recursor will redirect requests to Authoritative server only
      for the ".sitest" zone, other requests will be redirected
      to the server from settings.DNS_NAMESERVER
    """
    bootstrap = bootstrap_manager.BootstrapManager.get_si_config_bootstrap_manager()
    pdns = pdns_manager.PDNSManager(bootstrap_manager=bootstrap)
    # Do not use "local" zone because it is filtered as unsafe in systemd-resolve service by default
    local_zones = [settings.SEED_PDNS_LOCAL_ZONE]
    LOG.info(f"Install and configure PowerDNS on the seed node IP {pdns.seed_node_ip}")
    LOG.info(f"The following zones will be redirected to the Authoritative server: {local_zones}")
    pdns.install_pdns(local_zones=local_zones, upstream_nameserver=settings.DNS_NAMESERVER)
