#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz7609]='UBe8JslLZln0' \
[cz7630]='UBe8JslLZln0' \
[cz7631]='UBe8JslLZln0' \
[cz7635]='UBe8JslLZln0' \
[cz7732]='UBe8JslLZln0' \
[cz7729]='UBe8JslLZln0' \
[cz7816]='UBe8JslLZln0' \
[cz7893]='UBe8JslLZln0' \
[cz7900]='UBe8JslLZln0' \
[cz7638]='UBe8JslLZln0' \
[cz7639]='UBe8JslLZln0' \
[cz7633]='UBe8JslLZln0' \
[cz7632]='UBe8JslLZln0' \
[cz7637]='UBe8JslLZln0' \
[cz7747]='UBe8JslLZln0' \
[cz8177]='UBe8JslLZln0'
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz7635]='185.8.59.240' [cz7732]='5.43.225.73' \
               [cz7729]='5.43.225.32' [cz7816]='176.74.216.160' \
               [cz7893]='5.43.225.239' [cz7900]='5.43.225.245' \
               [cz7638]='185.8.59.243' [cz7639]='185.8.59.244' \
               [cz7633]='185.8.59.235' [cz7632]='185.8.59.236' \
               [cz7637]='185.8.59.242' [cz7747]='5.43.225.82' \
               [cz8177]='5.43.225.152')

  nodes_mgmt=([cz7609]='185.8.59.239' [cz7630]='185.8.59.238' \
              [cz7631]='185.8.59.237')
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action
    set +x
  done
 }

