#    Author: Alex Savatieiev (osavatieiev@mirantis.com; a.savex@gmail.com)
#    Copyright 2019-2022 Mirantis, Inc.
import sys


class cl_typewriter(object):
    previous = 0
    carret = 0

    def cl_start(self, sttr):
        self.previous = self.carret
        self.carret += len(sttr)
        sys.stdout.write("\r{}".format(sttr))

    def cl_inline(self, sttr):
        self.carret += len(sttr)
        sys.stdout.write("{}".format(sttr))

    def cl_sameline(self, sttr):
        self.cl_inline("\r" + sttr)
        self.cl_flush()

    def cl_flush(self, newline=False):
        if newline:
            self.cl_inline("\n")
            self.carret = 0
        elif self.previous > self.carret:
            self.cl_inline(" "*(self.previous - self.carret))
        sys.stdout.flush()


class Progress(object):
    _strsize = 0
    _note_size = 0

    def __init__(self, max_index, bar_size=21):
        self.total = max_index
        # bar size in symbols
        self.bar_size = bar_size

    def write_progress(self, index, note=''):
        # calc index and percent values
        _suffix = ''
        new_size = len(note)
        if self._note_size > new_size:
            _suffix = ' '*(self._note_size - new_size)
        if index:
            _percent = (100 * index) // self.total
            _index = (self.bar_size * index) // self.total
        else:
            _percent = 0
            _index = 0

        # clear the line
        sys.stdout.write('\r')
        # print new progress
        _format = "[{:"+str(self.bar_size-1)+"}] {}/{} ({}%) {}"
        _progress_string = _format.format(
            '='*_index,
            index,
            self.total,
            _percent,
            note + _suffix
        )
        sys.stdout.write(_progress_string)
        # Save new note size and whole string size
        self._strsize = len(_progress_string)
        self._note_size = new_size
        sys.stdout.flush()

    def clearline(self):
        sys.stdout.write('\r')
        sys.stdout.write(' '*self._strsize)
        sys.stdout.write('\r')
        sys.stdout.flush()

    def end(self):
        self._note_size = 0
        self._strsize = 0
        sys.stdout.write('\n')
