import base64
import os

import exec_helpers
import pytest

from si_tests import settings
from si_tests.managers import bootstrap_manager


def get_bootstrap_versions():
    bootstrap_versions = []
    prefix = "[bootstrap-version"
    suffix = "]"
    message = os.environ.get('GERRIT_CHANGE_COMMIT_MESSAGE', '')
    decoded_message = base64.b64decode(message).decode('utf-8')
    for line in decoded_message.splitlines():
        if line.startswith(prefix) and line.endswith(suffix):
            version = line.lstrip(prefix).rstrip(suffix).strip()
            if version:
                bootstrap_versions.append(version)
    return bootstrap_versions


@pytest.mark.parametrize("bootstrap_version", get_bootstrap_versions())
def test_bootstrap_template(bootstrap_version):
    """Check bootstrap templates

       To activate the check, please specify the bootstrap template version
       in the Gerrit commit message, using the format:

       [bootstrap-version x.y.z]

       There may be multiple strings for different versions to check, for example:

       [bootstrap-version 1.29.9]
       [bootstrap-version 1.30.0]
       [bootstrap-version 1.30.4]
    """
    bootstrap = bootstrap_manager.BootstrapManager()
    localsh = exec_helpers.Subprocess()
    # hack to use local 'open' function instead of remote.
    localsh.open = open

    # get and unpack bootstrap tarball
    localsh.check_call(f"wget https://artifactory.mcp.mirantis.net/artifactory/binary-dev-kaas-virtual/"
                       f"core/bin/bootstrap-linux-{bootstrap_version}.tar.gz -O bootstrap.tar.gz")

    target_dir = "kaas-bootstrap"
    localsh.check_call(f"rm -rf {target_dir} || true; mkdir -p {target_dir}; tar -xf bootstrap.tar.gz -C {target_dir}")

    # bootstrap_version = self.get_bootstrap_version()

    if bootstrap.is_bootstrap_version_dev(bootstrap_version):
        # cover case, when we test upgrades in kaas/core repo
        bootstrap_version = 'master'

    bootstrap_templates_path = os.path.expanduser(
        settings.KAAS_BOOTSTRAP_TEMPLATES_DIR)
    bootstrap_templates_path = os.path.join(
        bootstrap_templates_path, f'templates_{bootstrap_version}')
    assert os.path.isdir(bootstrap_templates_path), f"Path {bootstrap_templates_path} not found"

    tmpl_orig = f"{target_dir}/templates/"
    bootstrap._check_templates(tmpl_orig, bootstrap_templates_path, localsh)
