import pytest

from si_tests import logger
from si_tests import settings
from si_tests.utils import utils
from si_tests.utils import waiters
LOG = logger.logger

cluster_name = settings.TARGET_CLUSTER
namespace_name = settings.TARGET_NAMESPACE


@pytest.mark.usefixtures("introspect_distribution_not_changed")
@pytest.mark.usefixtures("collect_downtime_statistics")     # Should be used if ALLOW_WORKLOAD == True
@pytest.mark.usefixtures('log_method_time')
def test_add_remove_ssh_keys(kaas_manager, show_step):
    """Test add and check ssh keypair

    Scenario:
        1. Create new keypair
        2. Add new key to cluster
        3. Wait for access to nodes with new key
        4. Delete key from cluster
        5. Wait for no access to nodes with deleted key

    """

    # Get namespace
    LOG.info(f"Namespace name: {namespace_name}")
    ns = kaas_manager.get_namespace(namespace_name)
    cluster = ns.get_cluster(cluster_name)
    new_key = utils.generate_keys()
    key_name = "key-" + utils.gen_random_string(4)
    file_path = '/tmp/' + key_name
    with open(file_path, 'w') as key_file:
        key_file.write(new_key['private'])
    public_key = "ssh-rsa " + new_key['public']
    show_step(1)
    new_key = ns.create_publickey(key_name, public_key)
    cluster_data = cluster.data
    publickeys_data = cluster_data[
        'spec']['providerSpec']['value'].get('publicKeys', [])
    publickeys_data.extend([{"name": key_name}])
    keys = {
           "spec": {
             "providerSpec": {
               "value": {
                   "publicKeys": publickeys_data
               }
             }
           }
         }
    show_step(2)
    cluster.patch(keys)
    show_step(3)
    waiters.wait(
        lambda: cluster.check.check_machines_access_with_given_key(
            ssh_key_file=file_path), timeout=600, interval=60)
    show_step(4)
    keys['spec']['providerSpec']['value']['publicKeys'].remove(
        {"name": key_name})
    cluster.patch(keys)
    new_key.delete()
    show_step(5)
    waiters.wait(
        lambda: not cluster.check.check_machines_access_with_given_key(
            ssh_key_file=file_path), timeout=600, interval=60)
