import random
import string

from si_tests import logger
from si_tests.lcm.openstack_lcm.policies import Policy
from si_tests.utils.utils import verify


LOG = logger.logger


def test_crud_operations_volume_policy(openstack_client_manager,
                                       policy_user):
    """Test CRUD operations  for volume policy
       https://mirantis.testrail.com/index.php?/cases/view/4963574

       Parameters required for test execution:
         - KUBECONFIG

       Setup environment:
       Create user with role member
    """
    user_name, password = policy_user
    http_exception = "HTTP 403"
    os_service = 'cinder'
    os_pod = 'cinder-api'
    policy = Policy(os_service, os_pod)
    letters = string.ascii_lowercase
    name_postfix = ''.join(random.choice(letters) for i in range(5))

    def _delete_resources():
        volume_list = openstack_client_manager.volume.list([])
        for volume in volume_list:
            if name_postfix in volume.get('Name'):
                openstack_client_manager.volume.delete(
                    [volume.get('ID')])

    try:
        get_policy_file_before_update = \
            ['/bin/sh', '-c',
             r' grep -rin "volume:create:\|volume:get_all:"'
             ' /etc/cinder/policy.d/02-custom.yaml']
        policy.check_policy_absent_before_update(
            get_policy_file_before_update)

        LOG.info("Step 1: Check that policy is absent. "
                 "Volume list is possible by admin and member users")
        step = 1

        volume = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_no_policy_admin_{name_postfix}"],
            combined_output=True)
        verify(http_exception not in volume["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create volume is possible by admin")
        volume_list = openstack_client_manager.volume.list(
           [], combined_output=True)
        verify(http_exception not in volume_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume list is possible by admin")
        volume = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_no_policy_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception not in volume["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create volume is possible by user")
        volume_list = openstack_client_manager.volume.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception not in volume_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume list is possible by user")

        LOG.info("Step 2: Add to osdpl new rule")
        step = 2
        policy_add_role = {'volume:create': '!', 'volume:get_all': '!'}

        policy.update_policy_osdpl(policy_add_role, step)

        LOG.info("Step 3: Check on cinder api pod policies was added")
        check_policy_file = ['/bin/sh', '-c',
                             ' cat /etc/cinder/policy.d/02-custom.yaml']
        policy.wait_policy_updated_on_pod(check_policy_file, policy_add_role,
                                          step)

        LOG.info("Step 4: Check that policy added. Cerate volume and volume"
                 "list are not possible by admin and member user")
        step = 4

        error_output = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_policy_not_admin_{name_postfix}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: Policy is updated. "
               "Create volume is not possible by admin")
        error_output = openstack_client_manager.volume.list(
            [], combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "volume list is not possible by admin")
        error_output = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_policy_not_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: Policy is updated. "
               "Create volume is not possible by user")
        error_output = openstack_client_manager.volume.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume is not possible by user")

        LOG.info("Step 5: Update policies. Check that policy added "
                 "on cinder api pod ")
        step = 5
        policy_update_role = {'volume:create': 'rule:admin_api',
                              'volume:get_all': 'rule:admin_api'}

        policy.update_policy_osdpl(policy_update_role, step)
        policy.wait_policy_updated_on_pod(check_policy_file,
                                          policy_update_role, step)

        LOG.info("Step 6: Check that policy was updated and volume can be "
                 "created only by admin, volume list "
                 "can be watched only by admin")
        step = 6

        volume = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_updated_policy_admin_{name_postfix}"],
            combined_output=True)
        verify(http_exception not in volume["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create volume is possible by admin")
        volume_list = openstack_client_manager.volume.list(
            [], combined_output=True)
        verify(http_exception not in volume_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume list is possible by admin")
        error_output = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_policy_updated_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: Policy is updated. "
               "Create volume is not possible by user")
        error_output = openstack_client_manager.volume.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume is not possible by user")

    finally:
        LOG.info("Step 7: Delete Policy. Check that policy was deleted and"
                 " result the same in first step ")
        step = 7
        policy_not_role = None
        policy.update_policy_osdpl(policy_not_role, step)

        policy.wait_policy_updated_on_pod(check_policy_file, {},
                                          step)

        volume = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_delete_policy_admin_{name_postfix}"],
            combined_output=True)
        verify(http_exception not in volume["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create volume is possible by admin")
        volume_list = openstack_client_manager.volume.list(
            [], combined_output=True)
        verify(http_exception not in volume_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume list is possible by admin")
        volume = openstack_client_manager.volume.create([
            "--size", "1", f"test_volume_delete_policy_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception not in volume["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create volume is possible by user")
        volume_list = openstack_client_manager.volume.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception not in volume_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Volume list is possible by user")

        LOG.info("Delete created resources")

        _delete_resources()
