from si_tests import logger
from si_tests import settings
from si_tests.utils import waiters
import time
import pytest

LOG = logger.logger
init_parent_handler = LOG.parent.handlers[0]


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
def test_ha_reboot(kaas_manager, show_step, cluster_condition_check, _):
    """Reboot every cluster node (one at a time)
    Precondition - all expected pods and their replicas must be presented
    The following scenario is executed for every node

    Scenario:
        1. SSH to node
        2. Collect uptime for machines
        3. Reboot node
        4. Wait till node is accessible
        5. Check if machine has been rebooted
        6. Check that all nodes are Ready
        7. Check that all pods are Running and Ready

    Expected: result - every node is rebooted and all pods on every node are
    Running and Ready after this operation.
    """

    if not LOG.parent.handlers or \
            LOG.parent.handlers[0] != init_parent_handler:
        LOG.parent.handlers.clear()
        LOG.parent.addHandler(init_parent_handler)
    namespace = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
    cluster = namespace.get_cluster(settings.TARGET_CLUSTER)
    nodes = cluster.get_machines()
    LOG.info("Checking precondition: all nodes are Ready")
    kubectl_client = cluster.k8sclient
    for node in nodes:
        show_step(1)
        LOG.info("Accessing {} node and rebooting it".format(node.name))
        show_step(2)
        init_uptime = node.get_uptime()
        show_step(3)
        node._run_cmd("sudo systemctl reboot",
                      check_exit_code=False,
                      ssh_key=settings.HA_TEST_PRIVATE_KEY_FILE)
        # TODO: better handling for BM clusters
        time.sleep(100)
        show_step(4)
        LOG.info("Waiting for node {} to be up".format(node.name))
        waiters.wait_pass(
            lambda: node._run_cmd(
                "hostname", ssh_key=settings.HA_TEST_PRIVATE_KEY_FILE),
            timeout=240)
        LOG.info("Waiting for k8s to be ready")
        waiters.wait_pass(
            lambda: kubectl_client.pods.list_all(), timeout=120)
        show_step(5)
        current_uptime = node.get_uptime()
        node.get_reboot_list()
        assert current_uptime > init_uptime, \
            "Node has not been rebooted. Uptime before reboot: {} and after reboot: {}".format(init_uptime,
                                                                                               current_uptime)
        LOG.info("{} has been rebooted".format(node.name))
        show_step(6)
        cluster.check.check_k8s_nodes(timeout=600)
        cluster.check.check_persistent_volumes_mounts()
        show_step(7)
        cluster.check.check_k8s_pods()
