

class EnvironmentWrongStatus(BaseException):
    def __init__(self, env_name, env_expected_status, env_actual_status):
        super(EnvironmentWrongStatus, self).__init__()
        self.env_name = env_name
        self.env_expected_status = env_expected_status
        self.env_actual_status = env_actual_status

    def __str__(self):
        return ("Environment '{0}' has wrong status: "
                "expected '{1}', got: '{2}'"
                .format(self.env_name,
                        self.env_expected_status,
                        self.env_actual_status))


class EnvironmentBadStatus(BaseException):
    def __init__(self, env_name, env_expected_status,
                 env_actual_status, wrong_resources):
        super(EnvironmentBadStatus, self).__init__()
        self.env_name = env_name
        self.env_expected_status = env_expected_status
        self.env_actual_status = env_actual_status
        self.wrong_resources = wrong_resources

    def __str__(self):
        return ("Environment '{0}' has bad status: "
                "expected '{1}', got: '{2}'\n{3}"
                .format(self.env_name,
                        self.env_expected_status,
                        self.env_actual_status,
                        self.wrong_resources))


class UnknownProviderException(Exception):
    pass


class InvalidServiceUserException(Exception):
    pass
