#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSInfraConnectivityMonitor(base.BaseModel):
    pass


class V1KaaSInfraConnectivityMonitorList(base.BaseModelList):
    pass


class KaaSInfraConnectivityMonitor(base.K8sNamespacedResource):
    resource_type = 'infraconnectivitymonitor'
    model = V1KaaSInfraConnectivityMonitor


class KaaSInfraConnectivityMonitorManager(base.K8sBaseManager):
    model = V1KaaSInfraConnectivityMonitorList
    resource_class = KaaSInfraConnectivityMonitor
    resource_group = 'kaas.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'infraconnectivitymonitors'
