#    Copyright 2019 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


class TimeoutError(Exception):
    pass


class OsHeatEnvironmentWrongStatus(BaseException):
    def __init__(self, env_name, env_expected_status, env_actual_status):
        super(OsHeatEnvironmentWrongStatus, self).__init__()
        self.env_name = env_name
        self.env_expected_status = env_expected_status
        self.env_actual_status = env_actual_status

    def __str__(self):
        return ("Environment '{0}' has wrong status: "
                "expected '{1}', got: '{2}'"
                .format(self.env_name,
                        self.env_expected_status,
                        self.env_actual_status))


class OsHeatEnvironmentBadStatus(BaseException):
    def __init__(self, env_name, env_expected_status,
                 env_actual_status, wrong_resources):
        super(OsHeatEnvironmentBadStatus, self).__init__()
        self.env_name = env_name
        self.env_expected_status = env_expected_status
        self.env_actual_status = env_actual_status
        self.wrong_resources = wrong_resources

    def __str__(self):
        return ("Environment '{0}' has bad status: "
                "expected '{1}', got: '{2}'\n{3}"
                .format(self.env_name,
                        self.env_expected_status,
                        self.env_actual_status,
                        self.wrong_resources))
