import pytest

from si_tests import settings
from si_tests import logger
from si_tests.utils import utils

LOG = logger.logger


@pytest.mark.aws
@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
@pytest.mark.usefixtures('store_cluster_kubeconfig')
@pytest.mark.parametrize("_", [f"CLUSTER_NAME={settings.KCM_CLUSTER_DEPLOYMENT_NAME}"])
def test_create_aws_eks_cluster(kcm_manager, show_step, _):
    """Deploy managed clusterdeployment on AWS

    Scenario:
        1. Collect env data
        2. Create or get NS and check cluster templates presence
        3. Create auth
        4. Prepare clusterdeployment config
        5. Create clusterdeployment
        6. Wait for clusterdeployment progress to finish
        7. Check expected pods, its statuses and k8s nodes
    """
    show_step(1)
    # TODO(va4st): Move to separated test with auth actions, determine auth parameters dynamically
    cluster_name = settings.KCM_CLUSTER_DEPLOYMENT_NAME
    namespace_name = settings.KCM_CLUSTER_DEPLOYMENT_NAMESPACE
    aws_static_id_name = f"ksi-aws-auth-static-{utils.gen_random_string(4)}"
    auth_secret_name = f"{aws_static_id_name}-secret"
    cred_name = f"{aws_static_id_name}-cred"

    show_step(2)
    ns = kcm_manager.get_or_create_namespace(namespace_name)
    clustertemplate = (settings.KCM_CLUSTER_TEMPLATE_NAME or
                       ns.get_latest_template_by_prefix('aws-eks', strategy='chart'))
    available_templates = [tmpl.name for tmpl in ns.get_cluster_templates()]
    assert clustertemplate in available_templates, (f"Clustertemplate {clustertemplate} not found in namespace "
                                                    f"{ns.name}. Available templates: {available_templates}")
    utils.check_expected_pods_template_exists(clustertemplate)

    show_step(3)
    auth_sec = ns.create_aws_auth_secret(name=auth_secret_name)
    aws_static_id = ns.create_aws_cluster_static_identity(aws_static_id_name, auth_sec)
    cred = ns.create_credential(name=cred_name, cred_object=aws_static_id)

    show_step(4)
    # TODO(va4st): make configurable through settings and add parameters verification before testrun
    config = ns.get_cluster_config(provider='eks')

    show_step(5)
    cld = ns.create_cluster_deployment(name=cluster_name,
                                       template=clustertemplate,
                                       credential=cred,
                                       config=config)
    LOG.info(f"Created clusterdeployment {cld.namespace}/{cld.name}")

    show_step(6)
    cld.check.check_cluster_readiness()

    show_step(7)
    cld.check.check_actual_expected_pods()
    cld.check.check_k8s_pods()
    cld.check.check_k8s_nodes()
