#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
from si_tests.clients.k8s import base


class K8sCustomResourceDefinition(base.K8sClusterScopedResource):
    resource_type = 'customresourcedefinition'

    def _read(self, **kwargs):
        return self._manager.api.read_custom_resource_definition(
            self.name, self.namespace, **kwargs)

    def _create(self, body, **kwargs):
        return self._manager.api.create_custom_resource_definition(
            self.namespace, body, **kwargs)

    def _patch(self, body, **kwargs):
        return self._manager.api.patch_custom_resource_definition(
            self.name, self.namespace, body, **kwargs)

    def _replace(self, body, **kwargs):
        return self._manager.api.replace_custom_resource_definition(
            self.name, self.namespace, body, **kwargs)

    def _delete(self, **kwargs):
        self._manager.api.delete_custom_resource_definition(
            self.name, self.namespace, **kwargs)


class K8sCustomResourceDefinitionManager(base.K8sBaseManager):
    resource_class = K8sCustomResourceDefinition

    @property
    def api(self):
        return self._cluster.api_apiextensions_v1

    def _list_all(self, **kwargs):
        return self.api.list_custom_resource_definition(**kwargs)

    def delete_collection(self, **kwargs):
        return self.api.delete_collection_custom_resource_definition(**kwargs)
