# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from si_tests.clients.gcore.box_api.models.api_services_inference_v1_volume import ApiServicesInferenceV1Volume
from si_tests.clients.gcore.box_api.models.v1_create_scale_request import V1CreateScaleRequest
from si_tests.clients.gcore.box_api.models.v1_flavor_ref import V1FlavorRef
from si_tests.clients.gcore.box_api.models.v1_ingress_opts import V1IngressOpts
from si_tests.clients.gcore.box_api.models.v1_logging import V1Logging
from si_tests.clients.gcore.box_api.models.v1_probes import V1Probes
from si_tests.clients.gcore.box_api.models.v1_registry_image_ref import V1RegistryImageRef
from si_tests.clients.gcore.box_api.models.v1_registry_ref import V1RegistryRef
from si_tests.clients.gcore.box_api.models.v1_registry_user_ref import V1RegistryUserRef
from typing import Optional, Set
from typing_extensions import Self

class V1CreateInferenceRequest(BaseModel):
    """
    V1CreateInferenceRequest
    """ # noqa: E501
    api_keys: Optional[List[StrictStr]] = Field(default=None, description="API keys assigned to the inference deployment")
    command: Optional[List[StrictStr]] = Field(default=None, description="Command of the inference")
    description: Optional[StrictStr] = Field(default=None, description="Description of the inference")
    envs: Optional[Dict[str, StrictStr]] = Field(default=None, description="Envs of the inference, global, will be overwritten if envs_per_region provided")
    envs_per_region: Optional[Dict[str, Dict[str, StrictStr]]] = Field(default=None, description="EnvsPerRegion env variables per region, will be merged with global envs")
    expose: Optional[StrictStr] = Field(default=None, description="Expose of the inference")
    flavor: V1FlavorRef
    host_header: Optional[StrictStr] = Field(default=None, description="HostHeader of the inference")
    image: Optional[StrictStr] = Field(default=None, description="Image of the inference")
    ingress_opts: Optional[V1IngressOpts] = None
    is_disabled: Optional[StrictBool] = Field(default=None, description="IsDisabled of the inference")
    is_ingress_disabled: Optional[StrictBool] = Field(default=None, description="IsIngressDisabled of the inference")
    listening_port: Annotated[int, Field(le=65535, strict=True, ge=1)] = Field(description="ListeningPort of the inference")
    logging: Optional[V1Logging] = None
    metadata: Optional[Dict[str, StrictStr]] = Field(default=None, description="Metadata of the inference")
    metrics_port: Optional[Annotated[int, Field(le=65535, strict=True, ge=1)]] = Field(default=None, description="MetricsPort of the inference. Defaults to listening_port if not set.")
    name: StrictStr = Field(description="Name of the inference")
    probes: Optional[V1Probes] = None
    pull_secret: Optional[StrictStr] = Field(default=None, description="PullSecret of the inference")
    regions: Annotated[List[StrictStr], Field(min_length=1)] = Field(description="Regions of the inference")
    registry: Optional[V1RegistryRef] = None
    registry_image: Optional[V1RegistryImageRef] = None
    registry_user: Optional[V1RegistryUserRef] = None
    scale_per_region: Dict[str, V1CreateScaleRequest] = Field(description="ScalePerRegion if set scale will be ignored and scale per region will be used")
    timeout: Optional[StrictInt] = Field(default=None, description="Timeout of the inference")
    tls_secret: Optional[StrictStr] = Field(default=None, description="Tls certificate name")
    volumes: Optional[List[ApiServicesInferenceV1Volume]] = Field(default=None, description="Volumes of the inference")
    __properties: ClassVar[List[str]] = ["api_keys", "command", "description", "envs", "envs_per_region", "expose", "flavor", "host_header", "image", "ingress_opts", "is_disabled", "is_ingress_disabled", "listening_port", "logging", "metadata", "metrics_port", "name", "probes", "pull_secret", "regions", "registry", "registry_image", "registry_user", "scale_per_region", "timeout", "tls_secret", "volumes"]

    @field_validator('expose')
    def expose_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['gcore-geodns', 'gcore-cdn']):
            raise ValueError("must be one of enum values ('gcore-geodns', 'gcore-cdn')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1CreateInferenceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of flavor
        if self.flavor:
            _dict['flavor'] = self.flavor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ingress_opts
        if self.ingress_opts:
            _dict['ingress_opts'] = self.ingress_opts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of logging
        if self.logging:
            _dict['logging'] = self.logging.to_dict()
        # override the default output from pydantic by calling `to_dict()` of probes
        if self.probes:
            _dict['probes'] = self.probes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of registry
        if self.registry:
            _dict['registry'] = self.registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of registry_image
        if self.registry_image:
            _dict['registry_image'] = self.registry_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of registry_user
        if self.registry_user:
            _dict['registry_user'] = self.registry_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in scale_per_region (dict)
        _field_dict = {}
        if self.scale_per_region:
            for _key_scale_per_region in self.scale_per_region:
                if self.scale_per_region[_key_scale_per_region]:
                    _field_dict[_key_scale_per_region] = self.scale_per_region[_key_scale_per_region].to_dict()
            _dict['scale_per_region'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1CreateInferenceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "api_keys": obj.get("api_keys"),
            "command": obj.get("command"),
            "description": obj.get("description"),
            "envs": obj.get("envs"),
            "envs_per_region": obj.get("envs_per_region"),
            "expose": obj.get("expose"),
            "flavor": V1FlavorRef.from_dict(obj["flavor"]) if obj.get("flavor") is not None else None,
            "host_header": obj.get("host_header"),
            "image": obj.get("image"),
            "ingress_opts": V1IngressOpts.from_dict(obj["ingress_opts"]) if obj.get("ingress_opts") is not None else None,
            "is_disabled": obj.get("is_disabled"),
            "is_ingress_disabled": obj.get("is_ingress_disabled"),
            "listening_port": obj.get("listening_port"),
            "logging": V1Logging.from_dict(obj["logging"]) if obj.get("logging") is not None else None,
            "metadata": obj.get("metadata"),
            "metrics_port": obj.get("metrics_port"),
            "name": obj.get("name"),
            "probes": V1Probes.from_dict(obj["probes"]) if obj.get("probes") is not None else None,
            "pull_secret": obj.get("pull_secret"),
            "regions": obj.get("regions"),
            "registry": V1RegistryRef.from_dict(obj["registry"]) if obj.get("registry") is not None else None,
            "registry_image": V1RegistryImageRef.from_dict(obj["registry_image"]) if obj.get("registry_image") is not None else None,
            "registry_user": V1RegistryUserRef.from_dict(obj["registry_user"]) if obj.get("registry_user") is not None else None,
            "scale_per_region": dict(
                (_k, V1CreateScaleRequest.from_dict(_v))
                for _k, _v in obj["scale_per_region"].items()
            )
            if obj.get("scale_per_region") is not None
            else None,
            "timeout": obj.get("timeout"),
            "tls_secret": obj.get("tls_secret"),
            "volumes": [ApiServicesInferenceV1Volume.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None
        })
        return _obj


