# V1OverviewResponse


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**allocated_resources** | **Dict[str, str]** | AllocatedResources contains the resources allocated in the installation | [optional] 
**clusters** | [**List[V1Cluster]**](V1Cluster.md) | Clusters contains the list of clusters in the installation | [optional] 
**nodes** | [**List[V1Node]**](V1Node.md) | Node contains the list of nodes in the installation | [optional] 
**regions** | [**List[ApiServicesOverviewV1Region]**](ApiServicesOverviewV1Region.md) | NodeGroups contains the list of node groups in the installation | [optional] 
**registries** | [**List[ApiServicesOverviewV1RegistryResponse]**](ApiServicesOverviewV1RegistryResponse.md) | Registries contains the list of registries in the installation | [optional] 
**registries_total** | **float** | RegistriesTotal is the total size of all registries in the installation in GiB | [optional] 
**registries_usage** | **float** | RegistriesUsage is the usage of all registries in the installation in GiB | [optional] 
**used_resources** | **Dict[str, str]** | UsedResources contains the resources used in the installation | [optional] 
**volumes** | [**List[V1VolumeResponse]**](V1VolumeResponse.md) | Volumes contains the list of volumes in the installation | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_overview_response import V1OverviewResponse

# TODO update the JSON string below
json = "{}"
# create an instance of V1OverviewResponse from a JSON string
v1_overview_response_instance = V1OverviewResponse.from_json(json)
# print the JSON string representation of the object
print(V1OverviewResponse.to_json())

# convert the object into a dict
v1_overview_response_dict = v1_overview_response_instance.to_dict()
# create an instance of V1OverviewResponse from a dict
v1_overview_response_from_dict = V1OverviewResponse.from_dict(v1_overview_response_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


