# SchemasApp


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**components** | [**Dict[str, SchemasAppComponent]**](SchemasAppComponent.md) | Components represent configurable parts of the application. The map&#39;s keys act as unique component identifiers, used for configuring components. | 
**cover_url** | **str** | CoverUrl is a static file link to the application&#39;s cover image. | 
**description** | **str** | Description provides a brief overview of the application. | 
**display_name** | **str** | DisplayName is the human-readable name of the application. | 
**name** | **str** | Name is a unique application identifier in the catalog. | 
**readme** | **str** | Readme contains detailed documentation or instructions for the application. | 
**tags** | **Dict[str, str]** | Tags is a collection of key-value pairs categorizing the application. | 

## Example

```python
from si_tests.clients.gcore.box_api.models.schemas_app import SchemasApp

# TODO update the JSON string below
json = "{}"
# create an instance of SchemasApp from a JSON string
schemas_app_instance = SchemasApp.from_json(json)
# print the JSON string representation of the object
print(SchemasApp.to_json())

# convert the object into a dict
schemas_app_dict = schemas_app_instance.to_dict()
# create an instance of SchemasApp from a dict
schemas_app_from_dict = SchemasApp.from_dict(schemas_app_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


