# si_tests.clients.gcore.box_api.QuotasApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**admin_create_quota**](QuotasApi.md#admin_create_quota) | **POST** /v1/admin/quotas/{project_name} | Create quota
[**admin_delete_quota**](QuotasApi.md#admin_delete_quota) | **DELETE** /v1/admin/quotas/{project_name} | Delete quota
[**admin_list_quota_resource_types**](QuotasApi.md#admin_list_quota_resource_types) | **GET** /v1/admin/quotas/resource-types | List available resource types
[**admin_list_quotas**](QuotasApi.md#admin_list_quotas) | **GET** /v1/admin/quotas | List quotas
[**admin_update_quota**](QuotasApi.md#admin_update_quota) | **PUT** /v1/admin/quotas/{project_name} | Update quota
[**get_admin_quota**](QuotasApi.md#get_admin_quota) | **GET** /v1/admin/quotas/{project_name} | Get quota
[**get_quota**](QuotasApi.md#get_quota) | **GET** /v1/quotas/{project_name} | Get quota


# **admin_create_quota**
> V1QuotaResponse admin_create_quota(project_name, v1_create_quota_request)

Create quota

Creates a new resource quota in the specified project using the provided resource limits.

Values must follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_quota_request import V1CreateQuotaRequest
from si_tests.clients.gcore.box_api.models.v1_quota_response import V1QuotaResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_quota_request = si_tests.clients.gcore.box_api.V1CreateQuotaRequest() # V1CreateQuotaRequest | Quota

    try:
        # Create quota
        api_response = api_instance.admin_create_quota(project_name, v1_create_quota_request)
        print("The response of QuotasApi->admin_create_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling QuotasApi->admin_create_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_quota_request** | [**V1CreateQuotaRequest**](V1CreateQuotaRequest.md)| Quota | 

### Return type

[**V1QuotaResponse**](V1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **admin_delete_quota**
> admin_delete_quota(project_name)

Delete quota

Deletes the quota for the specified project.

This operation cannot be undone. Make sure you have a backup if needed.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # Delete quota
        api_instance.admin_delete_quota(project_name)
    except Exception as e:
        print("Exception when calling QuotasApi->admin_delete_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **admin_list_quota_resource_types**
> V1ResourceTypesResponse admin_list_quota_resource_types()

List available resource types

Returns a list of available resource types that can be used in quotas.

These resource types can be used when creating or updating quotas.
Common resource types include: cpu, memory, ephemeral-storage, and nvidia.com/gpu.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_resource_types_response import V1ResourceTypesResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)

    try:
        # List available resource types
        api_response = api_instance.admin_list_quota_resource_types()
        print("The response of QuotasApi->admin_list_quota_resource_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling QuotasApi->admin_list_quota_resource_types: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ResourceTypesResponse**](V1ResourceTypesResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **admin_list_quotas**
> V1ListQuotasResponse admin_list_quotas()

List quotas

Retrieves a list of all quotas across all projects, including their resource limits and current usage.

Values follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

Example: `{"project": "my-project", "limits": {"cpu": "8", "ephemeral-storage": "100Gi", "memory": "16Gi", "nvidia.com/gpu": "2" }, "usage": {"paris": {"cpu": "0", "ephemeral-storage": "0", "memory": "0", "nvidia.com/gpu": "0"}}`

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_quotas_response import V1ListQuotasResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)

    try:
        # List quotas
        api_response = api_instance.admin_list_quotas()
        print("The response of QuotasApi->admin_list_quotas:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling QuotasApi->admin_list_quotas: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListQuotasResponse**](V1ListQuotasResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **admin_update_quota**
> V1QuotaResponse admin_update_quota(project_name, v1_update_quota_request)

Update quota

Updates the resource limits for the specified project's quota. The other fields will remain unchanged.

Values must follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_quota_response import V1QuotaResponse
from si_tests.clients.gcore.box_api.models.v1_update_quota_request import V1UpdateQuotaRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_update_quota_request = si_tests.clients.gcore.box_api.V1UpdateQuotaRequest() # V1UpdateQuotaRequest | Quota

    try:
        # Update quota
        api_response = api_instance.admin_update_quota(project_name, v1_update_quota_request)
        print("The response of QuotasApi->admin_update_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling QuotasApi->admin_update_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_update_quota_request** | [**V1UpdateQuotaRequest**](V1UpdateQuotaRequest.md)| Quota | 

### Return type

[**V1QuotaResponse**](V1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_admin_quota**
> V1QuotaResponse get_admin_quota(project_name)

Get quota

Retrieves the quota information for the specified project, including resource limits and current usage.

Values follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

Example: `{"project": "my-project", "limits": {"cpu": "8", "ephemeral-storage": "100Gi", "memory": "16Gi", "nvidia.com/gpu": "2" }, "usage": {"paris": {"cpu": "0", "ephemeral-storage": "0", "memory": "0", "nvidia.com/gpu": "0"}}`

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_quota_response import V1QuotaResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # Get quota
        api_response = api_instance.get_admin_quota(project_name)
        print("The response of QuotasApi->get_admin_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling QuotasApi->get_admin_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1QuotaResponse**](V1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_quota**
> V1QuotaResponse get_quota(project_name)

Get quota

Retrieves the quota information for the specified project, including resource limits and current usage.

Values follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

Example: `{"project": "my-project", "limits": {"cpu": "8", "ephemeral-storage": "100Gi", "memory": "16Gi", "nvidia.com/gpu": "2" }, "usage": {"paris": {"cpu": "0", "ephemeral-storage": "0", "memory": "0", "nvidia.com/gpu": "0"}}`

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_quota_response import V1QuotaResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.QuotasApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # Get quota
        api_response = api_instance.get_quota(project_name)
        print("The response of QuotasApi->get_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling QuotasApi->get_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1QuotaResponse**](V1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

