# si_tests.clients.gcore.box_api.ProjectsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_project**](ProjectsApi.md#v1_create_project) | **POST** /v1/admin/projects | Create project
[**v1_delete_project**](ProjectsApi.md#v1_delete_project) | **DELETE** /v1/admin/projects/{project_name} | Delete project
[**v1_list_projects**](ProjectsApi.md#v1_list_projects) | **GET** /v1/projects | List projects


# **v1_create_project**
> V1ProjectResponse v1_create_project(v1_create_project_request)

Create project

This endpoint creates a new project in the system.

Projects are isolated environments where users can deploy and manage their resources.
Each project has its own set of permissions and resources, allowing for clear separation
between different workloads or teams.

Use this endpoint when you need to:
- Create a new isolated environment for a team or application
- Set up a new project for a customer or department
- Organize resources into logical groups

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_project_request import V1CreateProjectRequest
from si_tests.clients.gcore.box_api.models.v1_project_response import V1ProjectResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.ProjectsApi(api_client)
    v1_create_project_request = si_tests.clients.gcore.box_api.V1CreateProjectRequest() # V1CreateProjectRequest | Project body

    try:
        # Create project
        api_response = api_instance.v1_create_project(v1_create_project_request)
        print("The response of ProjectsApi->v1_create_project:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ProjectsApi->v1_create_project: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_project_request** | [**V1CreateProjectRequest**](V1CreateProjectRequest.md)| Project body | 

### Return type

[**V1ProjectResponse**](V1ProjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_project**
> v1_delete_project(project_name)

Delete project

This endpoint removes a project from the system.

When a project is deleted, all resources within that project are also deleted.
This includes all deployments, services, and other resources that were created
within the project.

Warning: This operation cannot be undone. Make sure to back up any important data
before deleting a project.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.ProjectsApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # Delete project
        api_instance.v1_delete_project(project_name)
    except Exception as e:
        print("Exception when calling ProjectsApi->v1_delete_project: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_projects**
> V1ListProjectResponse v1_list_projects()

List projects

This endpoint retrieves a list of all projects accessible to the current user.

Projects are isolated environments where users can deploy and manage their resources.
This endpoint returns all projects that the user has access to, based on their permissions.
Superusers will see all projects in the system, while regular users will only see
projects they have been granted access to.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_project_response import V1ListProjectResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.ProjectsApi(api_client)

    try:
        # List projects
        api_response = api_instance.v1_list_projects()
        print("The response of ProjectsApi->v1_list_projects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ProjectsApi->v1_list_projects: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListProjectResponse**](V1ListProjectResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

