# si_tests.clients.gcore.box_api.NamespacesApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_namespace**](NamespacesApi.md#v1_create_namespace) | **POST** /v1/admin/namespaces | Create project
[**v1_delete_namespace**](NamespacesApi.md#v1_delete_namespace) | **DELETE** /v1/admin/namespaces/{namespace_name} | Delete project
[**v1_list_namespaces**](NamespacesApi.md#v1_list_namespaces) | **GET** /v1/namespaces | List projects


# **v1_create_namespace**
> V1NamespaceResponse v1_create_namespace(v1_create_namespace_request)

Create project

This endpoint creates a new project in the system.

DEPRECATED: Use /v1/admin/projects instead. This endpoint will be removed in a future version.
Note: Projects are the standard terminology in the user interface.
Projects are isolated environments where users can deploy and manage their resources.
Each project has its own set of permissions and resources, allowing for clear separation
between different workloads or teams.

Use this endpoint when you need to:
- Create a new isolated environment for a team or application
- Set up a new project for a customer or department
- Organize resources into logical groups

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_namespace_request import V1CreateNamespaceRequest
from si_tests.clients.gcore.box_api.models.v1_namespace_response import V1NamespaceResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NamespacesApi(api_client)
    v1_create_namespace_request = si_tests.clients.gcore.box_api.V1CreateNamespaceRequest() # V1CreateNamespaceRequest | Project body

    try:
        # Create project
        api_response = api_instance.v1_create_namespace(v1_create_namespace_request)
        print("The response of NamespacesApi->v1_create_namespace:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NamespacesApi->v1_create_namespace: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_namespace_request** | [**V1CreateNamespaceRequest**](V1CreateNamespaceRequest.md)| Project body | 

### Return type

[**V1NamespaceResponse**](V1NamespaceResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_namespace**
> v1_delete_namespace(namespace_name)

Delete project

This endpoint removes a project from the system.

DEPRECATED: Use /v1/admin/projects/{project_name} instead. This endpoint will be removed in a future version.
Note: Projects are the standard terminology in the user interface.
When a project is deleted, all resources within that project are also deleted.
This includes all deployments, services, and other resources that were created
within the project.

Warning: This operation cannot be undone. Make sure to back up any important data
before deleting a project.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NamespacesApi(api_client)
    namespace_name = 'namespace_name_example' # str | Project name

    try:
        # Delete project
        api_instance.v1_delete_namespace(namespace_name)
    except Exception as e:
        print("Exception when calling NamespacesApi->v1_delete_namespace: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **namespace_name** | **str**| Project name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_namespaces**
> V1ListNamespaceResponse v1_list_namespaces()

List projects

This endpoint retrieves a list of all projects accessible to the current user.

DEPRECATED: Use /v1/projects instead. This endpoint will be removed in a future version.
Note: Projects are the standard terminology in the user interface.
This endpoint returns all projects that the user has access to, based on their permissions.
Superusers will see all projects in the system, while regular users will only see
projects they have been granted access to.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_namespace_response import V1ListNamespaceResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NamespacesApi(api_client)

    try:
        # List projects
        api_response = api_instance.v1_list_namespaces()
        print("The response of NamespacesApi->v1_list_namespaces:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NamespacesApi->v1_list_namespaces: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListNamespaceResponse**](V1ListNamespaceResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

