import pytest

from si_tests import logger

LOG = logger.logger


@pytest.mark.usefixtures('log_method_time')
def test_restart_docker_tf_compute_node(tf_manager, show_step):
    # Added due to PRODX-28356
    """Restart docker with TF vRouter pod and check node isn't rebooted.

    Scenario:
        1. Get compute node with vrouter pod
        2. Restart docker
        3. Wait all pods are ready
        4. Check node wasn't restarted
    """
    show_step(1)
    pods = tf_manager.get_vrouter_pods()
    pod = pods.pop()
    node_name = pod.read().spec.node_name

    LOG.info("Docker service on node {node} will be restarted."
             "".format(node=node_name))
    cmd = "last reboot | grep -e '^reboot' | wc -l"
    before = tf_manager.exec_pod_cmd(node_name, cmd, verbose=False)['logs']

    show_step(2)
    tf_manager.exec_pod_cmd(node_name, "systemctl restart docker",
                            verbose=False)

    show_step(3)
    tf_manager.wait_pod_restarted(pod, timeout=300)
    tf_manager.wait_all_pods_on_node(node_name)
    pod.wait_ready()
    tf_manager.wait_tf_controllers_healthy()

    show_step(4)
    after = tf_manager.exec_pod_cmd(node_name, cmd, verbose=False)['logs']

    LOG.info(f"Number of reboots for node {node_name} (before/after): "
             f"{before}/{after}")
    assert before == after, \
        f"Unexpected number of reboots: expected {before}" \
        f"actual: {after}. Reboot wasn't expected"
