import pytest
from si_tests import logger
from si_tests import settings
from si_tests.utils import utils
LOG = logger.logger


@pytest.mark.parametrize("_", [f"CLUSTER_NAME={settings.TARGET_CLUSTER}"])
def test_fips(kaas_manager, _, show_step):
    """Verify FIPS for Cluster/Machine
    Note:
        The test is for component testing only and does not reflect the officially proposed UX.
    Scenario:
        1. Check that fips is installed and requires a reboot
        2. Reboot nodes
        3. Check that the fips is installed and the node is rebooted
        4. Check return cluster to init state
     """

    cluster_name = settings.TARGET_CLUSTER
    namespace_name = settings.TARGET_NAMESPACE
    ns = kaas_manager.get_namespace(namespace_name)
    cluster = ns.get_cluster(cluster_name)
    machines = cluster.get_machines()
    show_step(1)
    for machine in machines:
        if machine.host_platform == 'ubuntu':
            assert "enabled" in (
               machine.exec_pod_cmd("sudo ua status | grep fips-updates")['logs']), (
                f"Fips not installed on node {machine.name}"
            )
            assert "FIPS support requires system reboot" in machine.exec_pod_cmd(
                "sudo ua status")['logs'], (
                f"fips installed and node {machine.name} have already been reloaded")

    show_step(2)
    machines_uptime_before = cluster.get_machines_uptime()
    for machine in machines:
        if machine.host_platform == 'ubuntu':
            if cluster.provider == utils.Provider.equinixmetalv2:
                machine.exec_pod_cmd("sudo shutdown --reboot +1")
                cluster.check.wait_k8s_node_status(machine.get_k8s_node_name(), expected_status='NotReady',
                                                   timeout=720)
                cluster.check.wait_k8s_node_status(machine.get_k8s_node_name(), expected_status='Ready',
                                                   timeout=720)
                LOG.info(f"Machine has been updated {machine.name}")
            else:
                machine.exec_pod_cmd("sudo reboot")

    machines_uptime_after = cluster.get_machines_uptime()

    for machine in machines:
        if machine.host_platform == 'ubuntu':
            assert machines_uptime_after[machine.name] > machines_uptime_before[machine.name], (
                f"Node {machine.name} has not been reloaded"
            )

    show_step(3)
    for machine in machines:
        if machine.host_platform == 'ubuntu':
            assert "enabled" in (
               machine.exec_pod_cmd("sudo ua status | grep fips-updates")['logs']), (
                f"Fips not installed on node {machine.name}"
            )
            assert "FIPS support requires system reboot" not in machine.exec_pod_cmd(
                "sudo ua status")['logs'], (
                f"fips installed and node {machine.name} needs reboot")

    show_step(4)
    cluster.check.check_k8s_nodes()
    cluster.check.check_machines_status()
    cluster.check.check_cluster_readiness()
    cluster.check.check_deploy_stage_success()
    LOG.info(f"Fips has been successfully installed on the cluster {cluster.name}")
