import pytest

from si_tests import logger
from si_tests import settings
from si_tests.managers.k8s_conformance_manager import K8SConformanceManager
from si_tests.utils.utils import Provider

LOG = logger.logger


@pytest.mark.parametrize("_", ["CLUSTER_NAME={0}"
                               .format(settings.TARGET_CLUSTER)])
@pytest.mark.usefixtures("store_cluster_description")
def test_k8s_conformance(kaas_manager, k8s_prerequisites, _):

    secret_name = k8s_prerequisites.secret_name
    conformance_version = k8s_prerequisites.conformance_version
    LOG.info("***** Secret name: {0}".format(secret_name))

    ns = kaas_manager.get_namespace(namespace=settings.TARGET_NAMESPACE)
    cluster = ns.get_cluster(settings.TARGET_CLUSTER)
    byo_cluster = True if cluster.provider is Provider.byo else False

    k8s_conformance_manager = K8SConformanceManager(
      k8s_prerequisites.parent_cluster)

    pod = k8s_conformance_manager.run_tests(
        secret_name=secret_name,
        conformance_version=conformance_version,
        byo_cluster=byo_cluster)

    k8s_conformance_manager.wait_test_results(
        pod=pod, timeout=settings.K8S_CONFORMANCE_RESULTS_WAIT_TIMEOUT
    )

    k8s_conformance_manager.download_test_results(pod, settings.TARGET_CLUSTER)

    k8s_conformance_pass = k8s_conformance_manager.check_test_results(pod)
    pod.delete()

    # Checking all pods are in consistent state after test run
    cluster.check.check_k8s_pods()

    if settings.K8S_CONFORMANCE_CHECK_RESULTS:
        assert k8s_conformance_pass,  "Some of k8s_conformance tests failed"
