from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_kaas_bm_deployments(kaas_manager):
    ns = settings.BM_DEFAULT_NS
    bm_deploys_list = ['ironic',
                       'ironic-inspector',
                       'dnsmasq',
                       'baremetal-operator',
                       'baremetal-provider']

    for deploy_name in bm_deploys_list:
        deploy = kaas_manager.api.deployments. \
            get(name=deploy_name, namespace=ns)
        assert deploy.is_ready, \
            "Deployment {} is not ready".format(deploy_name)


def test_kaas_bm_metallb_pods(kaas_manager):
    ns = settings.BM_METALLB_NS
    pod_list = kaas_manager.api.pods.list(namespace=ns,
                                          label_selector="app==metallb")
    assert len(pod_list) != 0, \
        "Pods in {} namespace were not found".format(ns)
    for pod in pod_list:
        phase = kaas_manager.api.pods.status(name=pod.name, namespace=ns)
        phase = phase.status.phase
        assert phase == 'Running', \
            "Pod {} is not running. State is: {}".format(pod.name, phase)
