variable "cluster_name" {
  type        = string
  description = "The global cluster name"
}

variable "aws_region" {
  type        = string
  description = "AWS region name"
}

variable "aws_shared_credentials_file" {
  default = "~/.aws/credentials"
}

variable "aws_profile" {
  default = "default"
}

variable "vpc_cidr" {
  default = "172.31.0.0/16"
}

variable "mke_username" {
  default = "admin"
}

variable "mke_version" {
  type        = string
  description = "MKE version to deploy"
}

variable "mke_repo" {
  type        = string
  description = "MKE repository URL"
}

variable "mcr_channel" {
  type        = string
  description = "MCR channel to use"
  default     = "stable"
}

variable "mcr_version" {
  type        = string
  description = "MCR version to deploy"
  default     = "20.10.12"
}

variable "mcr_repo" {
  type        = string
  description = "MCR repository URL"
  default     = "https://repos.mirantis.com"
}

variable "managers_count" {
  type        = number
  description = "Number of Management Instances"
}

variable "workers_count" {
  type        = number
  description = "Number of Workers Instances"
}

variable "windows_worker_count" {
  default = 0
}

variable "msr_count" {
  default = 0
}

variable "manager_type" {
  type        = string
  description = "AWS flavor for managers"
}

variable "worker_type" {
  type        = string
  description = "AWS flavor for workers"
}

variable "msr_type" {
  type        = string
  description = "AWS flavor for msr"
}
variable "master_volume_size" {
  default = 35
}

variable "worker_volume_size" {
  default = 35
}

variable "msr_volume_size" {
  default = 35
}
variable "windows_administrator_password" {
  default = "w!ndozePassw0rd"
}

variable "ami_id" {
  type        = string
  description = "Image name to use in AWS"
}

variable "ssh_username" {
  type        = string
  description = "ssh username"
}