#!/usr/bin/env bash


function _KILL_JOBS() {
  for pid in $(jobs -r -p); do
    if [[ $(ps -p $pid) && $? -eq 0 ]]; then
      kill $pid
    fi
  done
}

function _INT_TERM() {
  echo ""
  echo ["EXIT"]

  _KILL_JOBS

  exit 1;
}

trap _INT_TERM INT TERM
trap _KILL_JOBS EXIT


function set_power(){
  local ACTION=${1:-'status'}
  local TARGET=${2:-'all'}

  local DEFAULT_IPMI="172.18.168.10"
  local DEFAULT_LOGIN="admin"
  local DEFAULT_PASSWORD="password"

  # name ipmi_ip ipmi_port ipmi_login ipmi_password
  local MGMT=(
    'vm-409-0' $DEFAULT_IPMI '50080' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-409-1' $DEFAULT_IPMI '50081' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-409-2' $DEFAULT_IPMI '50082' $DEFAULT_LOGIN $DEFAULT_PASSWORD
  )

  local CHILD=(
    'vm-409-3' $DEFAULT_IPMI '50083' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-409-4' $DEFAULT_IPMI '50084' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'vm-409-5' $DEFAULT_IPMI '50085' $DEFAULT_LOGIN $DEFAULT_PASSWORD
    'cz8081-kvm' '5.43.227.159' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8082-kvm' '5.43.227.127' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8070-kvm' '5.43.227.62'  '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz7604-kvm' '185.8.59.215' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz7806-kvm' '185.8.59.254' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz7807-kvm' '5.43.225.140' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz9050-kvm' '5.43.227.243' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz5727-kvm' '5.43.227.164' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz7855-kvm' '5.43.225.106' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8117-kvm' '5.43.227.142' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8068-kvm' '5.43.227.113' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8069-kvm' '5.43.227.114' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz10112-d1z1' '5.43.229.141' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10113-d1z1' '5.43.229.142' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10118-d1z1' '5.43.229.147' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10119-d1z1' '5.43.229.148' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10120-d1z1' '5.43.229.149' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10121-d1z1' '5.43.229.150' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10122-d1z1' '5.43.229.151' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10123-d1z1' '5.43.229.152' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10124-d1z1' '5.43.229.153' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10125-d1z1' '185.8.58.175' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz10126-d1z1' '185.8.58.177' '623' 'engineer' 'UTsdUfyscwsi6t'
    'cz7866-kvm' '5.43.225.175' '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8038-kvm' '5.43.227.81'  '623' 'engineer' 'YUB1UYF98jkunsYUT'
    'cz8051-kvm' '5.43.227.94'  '623' 'engineer' 'YUB1UYF98jkunsYUT'
  )

  case $TARGET in
    mgmt) ARR=( ${MGMT[@]} );
      ;;
    child) ARR=( ${CHILD[@]} );
      ;;
    all) ARR=( ${MGMT[@]} ${CHILD[@]} );
      ;;
  esac

  for i in $(seq 0 5 $(expr ${#ARR[@]} - 1)); do
    echo "node: ${ARR[i]}"
    CMD=(ipmitool -I lanplus -H ${ARR[i+1]} -p ${ARR[i+2]} -U ${ARR[i+3]} -P ${ARR[i+4]} chassis power $ACTION)
    echo ${CMD[@]}

    ${CMD[@]}
  done
}

#main
if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    set_power "$@"
fi