import pytest

from si_tests.clients.iam import keycloak_client
from si_tests import settings


@pytest.fixture(scope='session')
def keycloak_ip(kaas_manager):
    return kaas_manager.get_keycloak_ip()


@pytest.fixture(scope='session')
def keycloak_admin_client(kaas_manager, keycloak_ip):
    # 1) we assume Keycloak contains keycloak user in IAM and Master realms
    # by default
    # 2) This user is the only one that can create other users

    pwd = kaas_manager.get_secret_data('iam-api-secrets',
                                       'kaas', 'keycloak_password')

    return keycloak_client.KeycloakAdminClient(ip=keycloak_ip,
                                               user=settings.KEYCLOAK_USER,
                                               password=pwd)
